# 機能設計書 55-ネットワークデバイスドライバ

## 概要

本ドキュメントは、FreeBSDにおける各種イーサネット・Wi-Fiデバイスドライバ群の設計を記述する。多数のネットワークデバイスドライバがsys/dev/以下に実装されており、有線・無線ネットワークへのアクセスを提供する。

### 本機能の処理概要

ネットワークデバイスドライバ群は、多種多様なネットワークインタフェースカード（NIC）を制御し、FreeBSDのネットワークスタックにパケットの送受信機能を提供する。各ドライバはifnet（ネットワークインタフェース）フレームワークに準拠し、上位のTCP/IPプロトコルスタックとの統一的なインタフェースを実現する。

**業務上の目的・背景**：ネットワーク接続はサーバ・デスクトップシステムの基本機能であり、多様なハードウェアベンダのNICをサポートすることが重要である。Broadcom、Intel、Qualcomm Atheros等の主要ベンダのNICドライバを提供し、有線1GbE/10GbE/25GbE/100GbE、無線802.11a/b/g/n/ac等の幅広いネットワーク接続をサポートする。

**機能の利用シーン**：システム起動時のNIC検出と初期化、ifconfigによるインタフェース設定、パケット送受信、VLANタギング、チェックサムオフロード、TSO/LRO等のハードウェアオフロード機能の利用。

**主要な処理内容**：
1. NICハードウェアの検出・初期化（PCI/PCIe）
2. DMAバッファの管理
3. パケット送信処理（TX ring管理）
4. パケット受信処理（RX ring管理）
5. 割り込み処理（MSI-X対応、マルチキュー）
6. ハードウェアオフロード（チェックサム、TSO、LRO）
7. VLAN HWフィルタリング
8. Promiscuousモード/マルチキャスト管理
9. リンク状態監視
10. 無線LAN固有処理（スキャン、認証、暗号化）

**関連システム・外部連携**：ifnet（ネットワークインタフェース）フレームワーク、TCP/IPプロトコルスタック、BPF（パケットキャプチャ）、ieee80211（無線LAN）フレームワークとの連携。

**権限による制御**：カーネルドライバとして動作。インタフェース設定（ifconfig）にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | 無線LAN設定画面 | 補助機能 | 無線LANデバイスの検出・wlanインターフェース作成 |
| 27 | ファームウェアインストール画面 | 補助機能 | ネットワーク・デバイスファームウェアパッケージの特定 |

## 機能種別

デバイスドライバ / ネットワークI/O

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| PCI Device ID | uint32 | Yes | NICのPCIデバイスID | 対応デバイスリストに一致 |
| mbuf | struct mbuf | Yes | 送信パケットデータ | 有効なmbufチェーン |
| ifconfigパラメータ | various | No | インタフェース設定 | 有効な設定値 |

### 入力データソース

- PCI構成空間（デバイス検出）
- mbuf（送信パケット）
- ioctl（インタフェース設定）
- NICレジスタ（ステータス読み取り）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 受信パケット | struct mbuf | 受信データ（mbufチェーン） |
| リンク状態通知 | event | リンクアップ/ダウンイベント |
| 統計情報 | counter | 送受信パケット数、エラー数等 |

### 出力先

- ネットワークスタック（受信パケットはif_input経由）
- BPF（パケットキャプチャ）
- sysctl（統計情報）
- dmesg（デバイスログ）

## 処理フロー

### 処理シーケンス

```
1. デバイス検出（probe）
   └─ PCI IDに基づくNIC識別
2. デバイスアタッチ（attach）
   └─ レジスタマッピング、割り込み設定、DMAバッファ割り当て
3. ifnet登録
   └─ ネットワークインタフェースとしてカーネルに登録
4. インタフェースUP
   └─ ifconfig up時にNIC初期化、TX/RX ring設定
5. パケット送信
   └─ if_transmit → ドライバTX関数 → DMA転送 → TX完了
6. パケット受信
   └─ RX割り込み → DMA完了 → mbuf構築 → if_input
7. リンク状態監視
   └─ リンク変更割り込み → if_link_state_change通知
```

### フローチャート

```mermaid
flowchart TD
    A[PCI probe] --> B[attach - リソース確保]
    B --> C[ifnet登録]
    C --> D{ifconfig up}
    D --> E[NIC初期化]
    E --> F[TX/RX ring設定]
    F --> G[割り込み有効化]
    G --> H[パケット送受信待ち]
    H --> I{イベント種別}
    I -->|TX要求| J[TX ringに投入]
    I -->|RX割り込み| K[RX ringから取得]
    I -->|リンク変更| L[リンク状態通知]
    J --> M[DMA転送]
    K --> N[mbuf構築]
    N --> O[if_input]
    M --> H
    O --> H
    L --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | マルチキュー | MSI-X対応NICでは複数のTX/RXキューを使用 | MSI-X対応NIC |
| BR-55-02 | HWオフロード | チェックサム計算、TSO、LROをハードウェアに委譲 | 対応NIC/有効設定時 |
| BR-55-03 | VLANフィルタリング | ハードウェアVLANタグ挿入/除去 | VLAN対応NIC |
| BR-55-04 | Promiscuousモード | 全パケットを受信するモード | BPFアタッチ時等 |

### 計算ロジック

特になし（各ドライバ固有のリングバッファサイズ計算は個別実装に依存）。

## データベース操作仕様

該当なし（カーネルドライバ）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | リンクダウン | ケーブル断等 | if_link_state_change通知 |
| - | TX ring full | 送信バッファ枯渇 | パケットドロップ、フロー制御 |
| - | DMAエラー | DMA転送失敗 | NICリセット |
| - | ウォッチドッグタイムアウト | NIC応答なし | NICリセット |

### リトライ仕様

ウォッチドッグタイマーにより無応答状態を検出し、NICリセット後にリカバリ。

## トランザクション仕様

該当なし（パケット単位の送受信処理）。

## パフォーマンス要件

- ワイヤレート性能（10GbE、25GbE等の回線速度に近い性能）
- 低レイテンシの割り込み処理
- ポーリングモード（DEVICE_POLLING）によるCPU使用率最適化
- ジャンボフレーム対応（MTU 9000等）

## セキュリティ考慮事項

- Promiscuousモードはroot権限で設定
- 無線LANドライバはWPA/WPA2/WPA3暗号化をサポート（ieee80211フレームワーク経由）
- ファームウェアの整合性検証

## 備考

- 主要なイーサネットドライバ: bge（Broadcom）、bce（Broadcom NetXtreme II）、bnxt（Broadcom NetXtreme-C/E）、igb/em（Intel）、ix/ixl（Intel 10GbE/40GbE）
- 主要な無線LANドライバ: ath（Atheros）、bwn（Broadcom）、iwn/iwm/iwlwifi（Intel）
- 各ドライバはsys/dev/以下の個別ディレクトリに配置

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ネットワークインタフェースフレームワークを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | if_var.h | `sys/net/if_var.h` | ifnet構造体、ドライバコールバック定義 |
| 1-2 | if.c | `sys/net/if.c` | ifnetフレームワークのコア実装 |

**読解のコツ**: FreeBSDのネットワークドライバはifnetフレームワークに準拠する。if_transmit、if_input、if_ioctl等のコールバックが各ドライバで実装される。

#### Step 2: 代表的なドライバを読む（例: igb - Intel GbE）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | if_igb.c | `sys/dev/e1000/if_igb.c` | Intel GbEドライバのメイン実装 |

**主要処理フロー**:
- probe/attach: PCI IDマッチング、リソース確保
- init: NIC初期化、TX/RX ring設定
- transmit: mbufからDMAディスクリプタへの変換
- rxeof: 受信割り込み処理、mbuf構築

#### Step 3: 無線LANフレームワークを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ieee80211_var.h | `sys/net80211/ieee80211_var.h` | 802.11フレームワーク構造体 |

### プログラム呼び出し階層図

```
ネットワークスタック (TCP/IP)
    |
    +-- if_transmit()
    |   +-- ドライバ固有TX関数
    |       +-- DMAディスクリプタ設定
    |       +-- ドアベル書き込み
    |
    +-- if_input() ◀── ドライバRX割り込み
        +-- ether_demux()
            +-- ip_input() / ip6_input()

ドライバ初期化:
    PCI probe/attach
        +-- bus_alloc_resource() [IRQ, Memory]
        +-- if_alloc() [ifnet作成]
        +-- ether_ifattach() [イーサネットアタッチ]
        +-- bus_setup_intr() [割り込みハンドラ登録]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

mbuf (送信)  ────▶ ドライバTX関数           ────▶ NIC TX ring (DMA)
                    DMAディスクリプタ設定            ──▶ 物理ネットワーク

NIC RX ring  ◀──── 物理ネットワーク
(DMA受信)        RX割り込みハンドラ        ────▶ mbuf (受信)
                    mbuf構築                       ──▶ if_input()
                                                   ──▶ TCP/IPスタック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| if_var.h | `sys/net/if_var.h` | ヘッダ | ifnetフレームワーク定義 |
| if.c | `sys/net/if.c` | ソース | ifnetフレームワーク実装 |
| if_igb.c | `sys/dev/e1000/if_igb.c` | ソース | Intel GbEドライバ |
| if_bge.c | `sys/dev/bge/if_bge.c` | ソース | Broadcom GbEドライバ |
| if_bce.c | `sys/dev/bce/if_bce.c` | ソース | Broadcom NetXtreme IIドライバ |
| if_bnxt.c | `sys/dev/bnxt/if_bnxt.c` | ソース | Broadcom NetXtreme-C/Eドライバ |
| if_ath.c | `sys/dev/ath/if_ath.c` | ソース | Atheros無線LANドライバ |
| ieee80211_var.h | `sys/net80211/ieee80211_var.h` | ヘッダ | 802.11フレームワーク定義 |
