# 機能設計書 56-USBサブシステム

## 概要

本ドキュメントは、FreeBSDにおけるUSBデバイスドライバフレームワークおよび各種USBドライバの設計を記述する。USBサブシステムはUSBホストコントローラの制御からUSBデバイスクラスドライバまでの階層的なアーキテクチャを提供する。

### 本機能の処理概要

USBサブシステムは、USB 1.x/2.0/3.x仕様に準拠したUSBデバイスの接続・管理・データ転送を行う包括的なフレームワークである。ホストコントローラドライバ（HCD）、USBコアスタック、各種クラスドライバの3層構造で構成される。

**業務上の目的・背景**：USBはPC周辺機器の標準的な接続インタフェースであり、キーボード、マウス、ストレージ、ネットワークアダプタ等の多種多様なデバイスをサポートする必要がある。FreeBSDのUSBサブシステムはHans Petter Selaskyにより再設計され、高性能かつ安定したUSBデバイスサポートを提供する。

**機能の利用シーン**：USBデバイスのホットプラグ接続、USBマスストレージ（USBメモリ等）へのアクセス、USB-Ethernet/Wi-Fiアダプタの利用、USBシリアルデバイスの接続、USBオーディオデバイスの使用。

**主要な処理内容**：
1. USBホストコントローラの検出・初期化（EHCI/OHCI/UHCI/xHCI）
2. USBデバイスの列挙（エニュメレーション）
3. USBデバイスの構成（Configuration）
4. USB転送の管理（Control/Bulk/Interrupt/Isochronous）
5. USBハブ処理
6. USBデバイスのサスペンド/レジューム
7. USBクラスドライバの管理
8. USBデバイスの動的アタッチ/デタッチ
9. USB DMA管理
10. USBデバイスQuirk管理

**関連システム・外部連携**：devd（デバイスイベント通知）、CAM（USB大容量ストレージ）、サウンドシステム（USBオーディオ）、ネットワークスタック（USBネットワーク）との連携。

**権限による制御**：カーネルドライバとして動作。ユーザ空間からのUSBデバイスアクセスはlibusb経由。ugen（汎用USBデバイス）はデバイスノード権限による制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （カーネルドライバのため関連画面なし） | - | - |

## 機能種別

デバイスドライバフレームワーク / バスサブシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| USBデバイスディスクリプタ | struct | Yes | USBデバイスの識別情報 | 有効なUSBディスクリプタ形式 |
| USB転送リクエスト | struct usb_xfer | Yes | USB転送パラメータ | 有効な転送種別・サイズ |
| USBエンドポイント | uint8 | Yes | 転送先エンドポイント番号 | 0-15 |

### 入力データソース

- USBバス（デバイスディスクリプタ、転送データ）
- カーネル上位層（転送リクエスト）
- USBデバイスQuirkテーブル（既知デバイスの回避策）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 転送完了データ | buffer | USB転送の受信データ |
| デバイス接続イベント | event | デバイスアタッチ/デタッチ通知 |
| USB統計情報 | sysctl | 転送統計 |

### 出力先

- USBクラスドライバ（転送完了コールバック）
- devd（デバイスイベント通知）
- sysctl（統計情報）
- dmesg（デバイスログ）

## 処理フロー

### 処理シーケンス

```
1. ホストコントローラ検出
   └─ PCI probe/attachでEHCI/xHCI等を検出
2. USBバス初期化
   └─ ルートハブの初期化、ポーリング開始
3. デバイス接続検出
   └─ ポート状態変化の検出
4. デバイスエニュメレーション
   └─ デバイスディスクリプタ取得、アドレス割り当て
5. ドライバマッチング
   └─ VendorID/ProductID/Classに基づくドライバ選択
6. デバイスアタッチ
   └─ クラスドライバのprobe/attach呼び出し
7. 転送処理
   └─ Control/Bulk/Interrupt/Isochronous転送の実行
8. デバイスデタッチ
   └─ 切断検出、クラスドライバのdetach呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[HCDプローブ] --> B[USBバス初期化]
    B --> C[ルートハブポーリング]
    C --> D{ポート変化?}
    D -->|Yes| E{接続/切断?}
    D -->|No| C
    E -->|接続| F[デバイスリセット]
    E -->|切断| G[デバイスデタッチ]
    F --> H[アドレス割り当て]
    H --> I[ディスクリプタ取得]
    I --> J[ドライバマッチング]
    J --> K[クラスドライバアタッチ]
    K --> L[転送準備完了]
    L --> C
    G --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | USBエニュメレーション | デバイス接続時にディスクリプタ取得とアドレス割り当てを自動実行 | デバイスホットプラグ時 |
| BR-56-02 | Quirk適用 | 既知の問題デバイスに対して自動的に回避策を適用 | 該当デバイス接続時 |
| BR-56-03 | 電力管理 | USBサスペンド/レジューム対応 | システムスリープ時 |
| BR-56-04 | 帯域管理 | Isochronous転送の帯域予約 | オーディオ/ビデオデバイス |

### 計算ロジック

USB帯域計算: USB 2.0では最大480Mbps、USB 3.0では最大5Gbps。Isochronous転送は最大帯域の80%まで予約可能。

## データベース操作仕様

該当なし（カーネルドライバ）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| USB_ERR_STALLED | エンドポイントストール | デバイスがリクエストを拒否 | CLEAR_FEATURE(HALT)送信 |
| USB_ERR_TIMEOUT | タイムアウト | デバイス応答なし | 転送リトライ/デバイスリセット |
| USB_ERR_SHORT_XFER | ショートパケット | 予期しない転送長 | 転送フラグにより許可/エラー |
| USB_ERR_CANCELLED | 転送キャンセル | デバイス切断等 | クリーンアップ処理 |

### リトライ仕様

Control転送はリトライ可能。Isochronous転送はリアルタイム性のためリトライなし。

## トランザクション仕様

USB転送はトランザクションベースで管理。各転送リクエスト（usb_xfer）はキューイングされ、順次実行される。

## パフォーマンス要件

- USB 2.0: 最大480Mbps（Hi-Speed）
- USB 3.0: 最大5Gbps（SuperSpeed）
- USB 3.1: 最大10Gbps（SuperSpeed+）
- ホットプラグ検出は通常1-2秒以内

## セキュリティ考慮事項

- USBデバイスは物理アクセスによる攻撃ベクタとなりうる（BadUSB等）
- ugen（汎用USBデバイス）へのアクセスはデバイスノード権限で制御
- USBデバイスQuirkにより既知の問題デバイスを管理

## 備考

- FreeBSDのUSBサブシステムはHans Petter Selasky (hselasky@FreeBSD.org) により再設計された
- sys/dev/usb/以下にコアスタック、controller/, input/, serial/, storage/, net/等のサブディレクトリにクラスドライバが配置
- USB gadget（デバイス側）機能もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | usb.h | `sys/dev/usb/usb.h` | USB仕様のデータ構造定義 |
| 1-2 | usbdi.h | `sys/dev/usb/usbdi.h` | USBドライバインタフェース定義 |
| 1-3 | usb_device.h | `sys/dev/usb/usb_device.h` | USBデバイス構造体 |

**読解のコツ**: FreeBSDのUSBサブシステムはusb_xfer（転送）を中心に設計されている。usb_core.cの**58-60行目**に見られるように、USB仕様ドキュメントへの参照がコメントに含まれている。

#### Step 2: USBコアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | usb_core.c | `sys/dev/usb/usb_core.c` | USBコアモジュール初期化 |
| 2-2 | usb_device.c | `sys/dev/usb/usb_device.c` | USBデバイス管理 |
| 2-3 | usb_dev.c | `sys/dev/usb/usb_dev.c` | /dev/ugenデバイスノード管理 |

#### Step 3: USBバスDMA管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | usb_busdma.c | `sys/dev/usb/usb_busdma.c` | USB DMAバッファ管理 |

#### Step 4: ホストコントローラドライバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | controller/ | `sys/dev/usb/controller/` | EHCI/OHCI/xHCI等のHCD実装 |

### プログラム呼び出し階層図

```
USBクラスドライバ (storage/, input/, net/, serial/)
    |
    +-- usbd_transfer_submit() [usbdi.h]
        |
        +-- USBコアスタック (usb_core.c, usb_device.c)
            |
            +-- usb_busdma (usb_busdma.c)
            |
            +-- ホストコントローラドライバ (controller/)
                +-- xhci / ehci / ohci / uhci
                    |
                    +-- USB物理バス

デバイス検出:
    USB HCD ポートステータス変化検出
        +-- usb_device_alloc() [usb_device.c]
            +-- usbd_get_desc() (ディスクリプタ取得)
            +-- device_probe_and_attach() (クラスドライバマッチング)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

USB転送リクエスト ──▶ USBコアスタック           ──▶ HCD (DMA転送)
(usb_xfer)            usb_transfer_submit()         ──▶ USBバス
                          |
USBバス         ◀──── HCD割り込み              ──▶ 転送完了コールバック
(デバイス応答)       usb_process()                  ──▶ クラスドライバ

デバイス接続     ──▶ usb_device_alloc()         ──▶ devd通知
(ポート変化)         device_probe_and_attach()      ──▶ デバイスノード作成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| usb.h | `sys/dev/usb/usb.h` | ヘッダ | USB仕様データ構造 |
| usbdi.h | `sys/dev/usb/usbdi.h` | ヘッダ | ドライバインタフェース |
| usb_core.c | `sys/dev/usb/usb_core.c` | ソース | コアモジュール |
| usb_device.c | `sys/dev/usb/usb_device.c` | ソース | デバイス管理 |
| usb_dev.c | `sys/dev/usb/usb_dev.c` | ソース | デバイスノード管理 |
| usb_busdma.c | `sys/dev/usb/usb_busdma.c` | ソース | DMA管理 |
| usb_dynamic.c | `sys/dev/usb/usb_dynamic.c` | ソース | 動的モジュールローディング |
| usb_error.c | `sys/dev/usb/usb_error.c` | ソース | エラーコード管理 |
| usb_debug.c | `sys/dev/usb/usb_debug.c` | ソース | デバッグ機能 |
| controller/ | `sys/dev/usb/controller/` | ディレクトリ | HCD実装群 |
| storage/ | `sys/dev/usb/storage/` | ディレクトリ | USBストレージドライバ |
| input/ | `sys/dev/usb/input/` | ディレクトリ | USB入力デバイスドライバ |
| net/ | `sys/dev/usb/net/` | ディレクトリ | USBネットワークドライバ |
| serial/ | `sys/dev/usb/serial/` | ディレクトリ | USBシリアルドライバ |
| quirk/ | `sys/dev/usb/quirk/` | ディレクトリ | デバイスQuirk定義 |
