# 機能設計書 60-コンソールドライバ

## 概要

本ドキュメントは、FreeBSDにおけるシステムコンソールおよび端末エミュレーションドライバ（vt/teken）の設計を記述する。vtドライバはカーネルレベルのコンソール管理を提供し、tekenライブラリは端末エスケープシーケンスの解釈を担当する。

### 本機能の処理概要

コンソールドライバは、vtドライバ（sys/dev/vt/）とtekenターミナルエミュレータ（sys/teken/）の組み合わせにより、テキストコンソール（仮想端末）の管理を行う。フレームバッファ出力、キーボード入力処理、仮想コンソール切替、フォント管理、マウスサポート等を提供する。

**業務上の目的・背景**：システムコンソールはOSの最も基本的なユーザインタフェースであり、ブートメッセージの表示、シングルユーザモードでの操作、カーネルデバッガとの対話に不可欠である。vtドライバは従来のsysconsドライバを置き換え、Unicodeサポート、フレームバッファ対応、改善されたマルチディスプレイサポートを提供する。

**機能の利用シーン**：システム起動時のブートメッセージ表示、テキストコンソールでのログイン/操作、仮想コンソール（Alt+F1〜F12）の切替、コンソールの解像度/フォント変更、sysmouse経由のマウスカーソル。

**主要な処理内容**：
1. VTデバイスの初期化と仮想ウィンドウ管理
2. フレームバッファバックエンドとの連携
3. tekenによる端末エスケープシーケンス解釈
4. キーボード入力処理
5. 仮想コンソール切替（Alt+Fn）
6. フォント管理（ビットマップフォントのロード/表示）
7. sysmouseサポート（コンソールマウス）
8. コンソールの色管理
9. ブートスプラッシュ画面
10. CPUロゴ表示
11. コンソール制御ioctl（CONS_*）
12. カーネルデバッガ（DDB）連携

**関連システム・外部連携**：DRMドライバ（フレームバッファ提供）、キーボードドライバ（kbdreg）、sysmouse、カーネルデバッガ（DDB）、terminal(4)フレームワークとの連携。

**権限による制御**：コンソールデバイス（/dev/ttyv*）へのアクセスはログインセッション管理に依存。vidcontrolコマンドによるコンソール設定にはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | （カーネルドライバのため関連画面なし） | - | - |

## 機能種別

デバイスドライバ / コンソール管理 / 端末エミュレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| キーボード入力 | keycode | Yes | キーボードスキャンコード | 有効なキーコード |
| エスケープシーケンス | string | No | 端末制御シーケンス | ANSIエスケープシーケンス形式 |
| ioctl | struct | No | コンソール制御コマンド | 有効なCONS_* ioctl |
| マウスイベント | struct mouse_info | No | マウス移動/クリック | 有効なマウスイベント |

### 入力データソース

- キーボードドライバ（kbdreg）
- アプリケーション出力（write to /dev/ttyv*）
- ioctl（vidcontrol等のコンソール設定）
- sysmouseドライバ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| フレームバッファ出力 | pixel/character | コンソール画面の描画 |
| キーボードイベント | keycode | アプリケーションへの入力 |
| コンソール状態 | sysctl | VT状態情報 |

### 出力先

- フレームバッファ（画面描画）
- /dev/ttyv*（端末デバイス）
- sysctl（hw.vt.*）

## 処理フロー

### 処理シーケンス

```
1. VTデバイス初期化
   └─ vt_device構造体の初期化、VT_MAXWINDOWS個の仮想ウィンドウ作成
2. フレームバッファバックエンド検出
   └─ VGA/EFI/DRM等のフレームバッファプロバイダとの接続
3. フォントロード
   └─ ビットマップフォントの読み込み
4. コンソール準備完了
   └─ ブートメッセージ表示開始
5. キーボード入力処理
   └─ キーコードをtekenに渡して端末入力処理
6. 文字出力処理
   └─ 出力データをtekenで解釈し、VTバッファに反映
7. 画面描画
   └─ VTバッファの変更部分をフレームバッファに描画
8. 仮想コンソール切替
   └─ Alt+Fnキーでアクティブウィンドウを切替
```

### フローチャート

```mermaid
flowchart TD
    A[VTデバイス初期化] --> B[フレームバッファ接続]
    B --> C[フォントロード]
    C --> D[コンソール準備完了]
    D --> E[イベント待ち受け]
    E --> F{イベント種別}
    F -->|キーボード| G[キーコード処理]
    F -->|文字出力| H[teken解釈]
    F -->|ioctl| I[コンソール制御]
    F -->|マウス| J[sysmouse処理]
    G --> K{特殊キー?}
    K -->|Alt+Fn| L[仮想コンソール切替]
    K -->|通常キー| M[アプリケーションに転送]
    H --> N[VTバッファ更新]
    N --> O[フレームバッファ描画]
    I --> O
    L --> O
    O --> E
    M --> E
    J --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-60-01 | 最大仮想ウィンドウ数 | VT_MAXWINDOWS（デフォルト12）個の仮想コンソール | VT初期化時 |
| BR-60-02 | ALT+ESCハック | Alt+ESCをエスケープシーケンスに変換（VT_ALT_TO_ESC_HACK=1） | デフォルト有効 |
| BR-60-03 | マウスペーストボタン | 中ボタンでペースト（2ボタンマウス時は右ボタン） | sysmouse有効時 |
| BR-60-04 | コンソールウィンドウ0 | VT_CONSWINDOW=0がデフォルトコンソール | 常時 |

### 計算ロジック

フレームバッファサイズ: 解像度（横x縦） x BPP。文字セルサイズ: フォント幅 x フォント高。表示可能文字数: (画面幅/フォント幅) x (画面高/フォント高)。

## データベース操作仕様

該当なし（カーネルドライバ）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | フレームバッファなし | GPUドライバ未ロード時 | テキストモードにフォールバック |
| - | フォント未ロード | フォントファイル不存在 | デフォルトビルトインフォント使用 |
| EINVAL | 不正ioctl | 不正なコンソール制御コマンド | エラーコード返却 |

### リトライ仕様

特になし。フレームバッファの取得失敗時はテキストモードにフォールバック。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- コンソール出力: フレームバッファの描画速度に依存
- スクロール: 大量出力時のスクロール性能
- 仮想コンソール切替: 即座（数ミリ秒以内）

## セキュリティ考慮事項

- コンソールアクセスは物理アクセスと同等のセキュリティレベル
- 仮想コンソール切替にはキーボード物理アクセスが必要
- securelevel設定によりコンソール操作を制限可能

## 備考

- vtドライバはEd Schouten/Oleksandr RybalkoによりFreeBSD Foundation支援の下で開発
- tekenは独立した端末エミュレーションライブラリとして実装されており、テストやデモ用のスタンドアロン環境も含む
- vtドライバはsysconsドライバの後継であり、UTF-8/Unicode対応、KMS連携等が強化されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | vt.h | `sys/dev/vt/vt.h` | VTデバイス/ウィンドウ構造体定義 |
| 1-2 | teken.h | `sys/teken/teken.h` | tekenターミナルエミュレータ構造体 |

**読解のコツ**: vt.hの**54-59行目**にVT_MAXWINDOWS（デフォルト12）の定義がある。**62-64行目**のVT_ALT_TO_ESC_HACKはAlt+ESCの変換設定。**66行目**のVT_CONSWINDOWはデフォルトコンソールのインデックス。**68-74行目**にマウスボタンのマッピング（SC_TWOBUTTONに応じた中/右ボタン設定）がある。**76行目**のSC_DRIVER_NAME="vt"がドライバ名。

#### Step 2: VTコアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | vt_core.c | `sys/dev/vt/vt_core.c` | VTドライバのコア実装 |

**主要処理フロー**:
1. **34-58行目**: ヘッダインクルード群（consio.h, fbio.h, font.h, kbio.h等）
2. **65-66行目**: vtterm_cngrab_noswitch/cnungrab_noswitch - コンソールgrab処理
3. **68-76行目**: tekenターミナルコールバック関数群（bell, cursor, putchar, fill, copy, pre_input, post_input, param, done）
4. **78-79行目**: cnprobe/cngetcコンソールプローブ関数

#### Step 3: tekenターミナルエミュレータを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | teken.c | `sys/teken/teken.c` | teken端末エミュレータ本体 |
| 3-2 | teken.h | `sys/teken/teken.h` | teken公開API |
| 3-3 | teken_subr.h | `sys/teken/teken_subr.h` | tekenサブルーチン |

**読解のコツ**: tekenは独立したライブラリであり、VTドライバ以外でも使用可能。teken_subr.hに端末エスケープシーケンス（カーソル移動、画面クリア等）の実装がある。

#### Step 4: バッファ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | vt_buf.c | `sys/dev/vt/vt_buf.c` | VTバッファ管理（スクロールバッファ等） |

#### Step 5: フォント管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | vt_font.c | `sys/dev/vt/vt_font.c` | ビットマップフォント管理 |

#### Step 6: ハードウェアバックエンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | hw/ | `sys/dev/vt/hw/` | フレームバッファバックエンド（VGA, EFI, DRM等） |

### プログラム呼び出し階層図

```
アプリケーション / カーネル
    |
    +-- write(/dev/ttyv*) → vtterm_putchar() [vt_core.c]
    |                          +-- teken_input() [teken.c]
    |                          |   +-- teken_subr.h (エスケープシーケンス解釈)
    |                          +-- vt_buf更新 [vt_buf.c]
    |                          +-- 画面描画 → hw/バックエンド
    |
    +-- キーボード入力 → vt_kbdevent()
    |                      +-- teken_input() (入力処理)
    |                      +-- 仮想コンソール切替判定
    |
    +-- ioctl(/dev/ttyv*) → vtterm_ioctl()
    |                          +-- CONS_*系ioctl処理
    |
    +-- sysmouse → vt_mouse_event()
                    +-- マウスカーソル描画

VTフォント管理 [vt_font.c]
    +-- ビットマップフォントのロード/アンロード

VTハードウェアバックエンド [hw/]
    +-- VGA / EFI / DRM フレームバッファ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

キーボード   ────▶ vt_kbdevent()              ────▶ アプリケーション入力
(スキャンコード)    キーコード変換                      (/dev/ttyv*)

文字出力     ────▶ teken_input()              ────▶ VTバッファ
(write)           エスケープシーケンス解釈            ↓
                   vtterm_putchar()                  ↓
                                               vt_buf.c (バッファ更新)
                                                     ↓
                                               hw/バックエンド ──▶ ディスプレイ
                                               (フレームバッファ描画)

ioctl        ────▶ vtterm_ioctl()              ────▶ コンソール設定変更
(vidcontrol)       CONS_*処理                         フォント変更等
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| vt.h | `sys/dev/vt/vt.h` | ヘッダ | VTデバイス構造体定義 |
| vt_core.c | `sys/dev/vt/vt_core.c` | ソース | VTコア実装 |
| vt_buf.c | `sys/dev/vt/vt_buf.c` | ソース | バッファ管理 |
| vt_font.c | `sys/dev/vt/vt_font.c` | ソース | フォント管理 |
| vt_sysmouse.c | `sys/dev/vt/vt_sysmouse.c` | ソース | マウスサポート |
| vt_consolectl.c | `sys/dev/vt/vt_consolectl.c` | ソース | コンソール制御 |
| vt_cpulogos.c | `sys/dev/vt/vt_cpulogos.c` | ソース | CPUロゴ表示 |
| teken.c | `sys/teken/teken.c` | ソース | 端末エミュレータ本体 |
| teken.h | `sys/teken/teken.h` | ヘッダ | teken公開API |
| teken_subr.h | `sys/teken/teken_subr.h` | ヘッダ | tekenサブルーチン |
| teken_subr_compat.h | `sys/teken/teken_subr_compat.h` | ヘッダ | 互換サブルーチン |
| teken_scs.h | `sys/teken/teken_scs.h` | ヘッダ | 文字セット変換 |
| teken_wcwidth.h | `sys/teken/teken_wcwidth.h` | ヘッダ | ワイド文字幅 |
| hw/ | `sys/dev/vt/hw/` | ディレクトリ | ハードウェアバックエンド |
| colors/ | `sys/dev/vt/colors/` | ディレクトリ | 色定義 |
| font/ | `sys/dev/vt/font/` | ディレクトリ | ビルトインフォント |
| logo/ | `sys/dev/vt/logo/` | ディレクトリ | ブートロゴ |
