# 機能設計書 62-bhyveハイパーバイザ

## 概要

本ドキュメントは、FreeBSD標準のType-2ハイパーバイザであるbhyveの機能設計を記述する。bhyveはホストOS上で仮想マシン（VM）を作成・実行するための仮想化基盤であり、Intel VT-xおよびAMD-Vハードウェア仮想化支援機能を利用して、ゲストOSを効率的に実行する。

### 本機能の処理概要

**業務上の目的・背景**：サーバ統合、開発環境の分離、テスト環境の構築、マルチOS運用など、仮想化技術は現代のIT基盤に不可欠である。bhyveはFreeBSDネイティブのハイパーバイザとして、カーネルモジュール（vmm.ko）とユーザランドツール群を組み合わせ、高性能な仮想マシン実行環境を提供する。

**機能の利用シーン**：FreeBSDホスト上でLinux、Windows、その他のOSをゲストとして実行する場合に利用される。本番環境でのサーバ仮想化、開発・テスト環境の構築、CI/CD環境の仮想マシン管理などで使用される。

**主要な処理内容**：
1. 仮想マシンの作成とメモリ割り当て（vmmapi経由）
2. 仮想CPU（vCPU）の設定とトポロジ構成（ソケット/コア/スレッド）
3. ACPI、PCI、ブートROMなどの仮想ハードウェアエミュレーション
4. ブロックデバイス（virtio-blk, AHCI）、ネットワーク（virtio-net, e1000）のエミュレーション
5. vCPU実行ループ（VM Entry/VM Exit処理）
6. GDB接続によるゲストデバッグ支援
7. NUMAトポロジのエミュレーション
8. スナップショット/リストア機能（BHYVE_SNAPSHOT有効時）

**関連システム・外部連携**：カーネルモジュール vmm.ko が仮想マシンモニタの中核を担う。vmmapi ライブラリを介してカーネルとの通信を行う。bhyvectl は仮想マシンの管理コマンド、bhyveload はFreeBSDゲスト用のブートローダである。

**権限による制御**：bhyveの実行にはroot権限またはvmm デバイスへのアクセス権限が必要。Capsicumサンドボックスに対応しており、初期化完了後にケイパビリティモードに移行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能にはGUI画面の関連はない |

## 機能種別

仮想マシン実行管理 / ハードウェアエミュレーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -c cpus | string | No | vCPUトポロジ（cpus=N,sockets=N,cores=N,threads=N） | 正の整数、上限あり |
| -m memsize | string | Yes | ゲストメモリサイズ（例: 1G, 512M） | 正のサイズ値 |
| -s slot,emulation[,conf] | string | No | PCIデバイスエミュレーション設定 | slot番号0-31 |
| -l lpc_device[,conf] | string | No | LPCデバイス設定 | 有効なデバイス名 |
| -o config | string | No | 設定変数の直接指定 | key=value形式 |
| -k config_file | string | No | UCL形式設定ファイル | 存在するファイル |
| vmname | string | Yes | 仮想マシン名 | 一意の名前 |

### 入力データソース

- コマンドライン引数
- UCL設定ファイル（-k指定時）
- ブートROMファイル（UEFI firmware）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| VM実行状態 | int | ゲストのVM Exit理由コード |
| コンソール出力 | bytes | ゲストOSのシリアルコンソール出力 |
| GDB接続 | socket | GDBリモートデバッグプロトコル |

### 出力先

- 標準出力/標準エラー出力: 起動メッセージ
- /dev/vmm/{vmname}: 仮想マシンデバイス
- GDBソケット: デバッグ接続

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ コマンドライン引数パース、設定ファイル読み込み
2. VM作成
   └─ vmmapi経由でカーネルにVM作成要求、メモリ割り当て
3. vCPU設定
   └─ トポロジ（ソケット/コア/スレッド）設定、cpusetマッピング
4. NUMA設定
   └─ メモリドメイン分配、ドメインポリシー設定
5. デバイスエミュレーション初期化
   └─ ACPI、PCI、LPC、ブートROM等の初期化
6. Capsicumサンドボックス
   └─ ケイパビリティモード移行（有効時）
7. vCPU実行ループ
   └─ VM Entry → ゲスト実行 → VM Exit → Exit理由処理 → 繰り返し
8. 終了処理
   └─ VM破棄、リソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[bhyve起動] --> B[設定パース]
    B --> C[VM作成・メモリ割り当て]
    C --> D[vCPU設定]
    D --> E[デバイスエミュレーション初期化]
    E --> F[ブートROMロード]
    F --> G{Capsicum有効?}
    G -->|Yes| H[ケイパビリティモード移行]
    G -->|No| I[vCPU実行ループ開始]
    H --> I
    I --> J{VM Exit理由}
    J -->|I/Oアクセス| K[デバイスエミュレーション処理]
    J -->|HLT| L[イベント待機]
    J -->|リセット| M[VM再起動/終了]
    J -->|トリプルフォルト| N[異常終了]
    K --> I
    L --> I
    M --> O{再起動?}
    O -->|Yes| C
    O -->|No| P[VM破棄・終了]
    N --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | CPUトポロジ解決 | cpus, sockets, cores, threadsの積がvCPU数と一致すること | -c オプション指定時 |
| BR-62-02 | メモリサイズ制限 | ゲストメモリは物理メモリ以下であること | 常時 |
| BR-62-03 | PCIスロット割り当て | スロット0:0はホストブリッジに予約 | PCI設定時 |
| BR-62-04 | NUMA分配 | ドメインサイズ未指定時は均等分配 | 複数NUMAドメイン時 |

### 計算ロジック

vCPU数 = sockets * cores * threads（明示指定がない場合はデフォルト各1）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。カーネルのvmmデバイスを通じてVM状態を管理する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EX_OSERR | VM作成失敗 | vmm.koが未ロード、またはメモリ不足 | カーネルモジュールロード確認 |
| EX_USAGE | パラメータ不正 | 無効なCPUトポロジやメモリサイズ | 使用方法を表示してexit |
| - | トリプルフォルト | ゲスト内の致命的エラー | VMを強制終了 |
| - | vCPU作成失敗 | cpusetの設定不正 | エラーメッセージ表示後exit |

### リトライ仕様

VM実行ループ内でのVM Exit処理は自動的に再実行される。ゲストリセット要求時はVMを再初期化して再起動する。

## トランザクション仕様

トランザクション管理は不要。VMの状態はカーネル内で管理される。

## パフォーマンス要件

- ハードウェア仮想化（VT-x/AMD-V）によるネイティブに近い実行速度
- vCPUごとにホストスレッドを割り当て、並列実行可能

## セキュリティ考慮事項

- Capsicumサンドボックスにより、初期化後はファイルシステムアクセスを制限
- ゲストからホストへのエスケープ防止はvmm.koカーネルモジュールが担当
- メモリ分離はハードウェアEPT/NPTによって保証

## 備考

- bhyve_snapshotビルドオプションによりスナップショット/リストア機能が有効化される
- GDBデバッグ機能はBHYVE_GDBビルドオプションで有効化される
- bhyvectlはVMの管理（作成・破棄・状態確認）を行うコンパニオンツール

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bhyverun.h | `usr.sbin/bhyve/bhyverun.h` | グローバル変数宣言（guest_ncpus, cpu_cores等） |
| 1-2 | config.h | `usr.sbin/bhyve/config.h` | UCL設定管理のAPI |
| 1-3 | vmmapi.h | ライブラリヘッダ | vmctx構造体、vCPU操作API |

**読解のコツ**: bhyveは多数のデバイスエミュレータを含む大規模プログラム。まずbhyverun.cのmain()とvm_loop()を理解し、そこから各デバイスに進むのが効率的。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bhyverun.c | `usr.sbin/bhyve/bhyverun.c` | main()関数 - 初期化・VM作成・vCPU実行ループ |

**主要処理フロー**:
1. **100-101行目**: MB/GBマクロ定義
2. **103-104行目**: guest_ncpus, cpu_cores等のグローバル変数
3. **137-174行目**: bhyve_topology_parse() - CPUトポロジ解析
4. **190-242行目**: bhyve_numa_parse() - NUMAドメイン設定
5. **244-299行目**: calc_mem_affinity() - メモリアフィニティ計算

#### Step 3: デバイスエミュレーション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pci_emul.c | `usr.sbin/bhyve/pci_emul.c` | PCIバスエミュレーション |
| 3-2 | block_if.c | `usr.sbin/bhyve/block_if.c` | ブロックデバイスインタフェース |
| 3-3 | acpi.c | `usr.sbin/bhyve/acpi.c` | ACPIテーブル生成 |

### プログラム呼び出し階層図

```
main() [bhyverun.c]
    |
    +-- parse_args() / config読み込み
    |
    +-- vm_open() [vmmapi] → /dev/vmm/{vmname}
    |
    +-- vm_setup_memory() [vmmapi]
    |       +-- calc_mem_affinity()
    |
    +-- init_pci() [pci_emul.c]
    |       +-- 各PCIデバイスエミュレータ初期化
    |
    +-- init_acpi() [acpi.c]
    |
    +-- vm_loop() [bhyverun.c]
            +-- pthread_create() → vCPUスレッド
                    +-- vm_run() [vmmapi] → VM Entry
                    +-- vmexit処理 [vmexit.c]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

コマンドライン引数 ──▶ bhyverun.c main() ────────▶ /dev/vmm/{vmname}
設定ファイル ────────┘         |                    (VM状態管理)
                               |
ブートROM ──────────▶ bootrom.c ──▶ ゲストメモリ
                               |
ゲストI/O要求 ◀────▶ pci_emul.c ◀───▶ ホストリソース
                     block_if.c         (ディスク/ネットワーク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bhyverun.c | `usr.sbin/bhyve/bhyverun.c` | ソース | メインエントリポイント、VM実行ループ |
| bhyverun.h | `usr.sbin/bhyve/bhyverun.h` | ヘッダ | グローバル宣言 |
| config.c | `usr.sbin/bhyve/config.c` | ソース | UCL設定管理 |
| pci_emul.c | `usr.sbin/bhyve/pci_emul.c` | ソース | PCIエミュレーション |
| block_if.c | `usr.sbin/bhyve/block_if.c` | ソース | ブロックデバイスI/F |
| acpi.c | `usr.sbin/bhyve/acpi.c` | ソース | ACPI対応 |
| bootrom.c | `usr.sbin/bhyve/bootrom.c` | ソース | ブートROM処理 |
| mevent.c | `usr.sbin/bhyve/mevent.c` | ソース | イベントループ基盤 |
| vmexit.c | `usr.sbin/bhyve/vmexit.c` | ソース | VM Exit処理 |
| gdb.c | `usr.sbin/bhyve/gdb.c` | ソース | GDBデバッグ支援 |
| bhyve.8 | `usr.sbin/bhyve/bhyve.8` | マニュアル | bhyveマニュアルページ |
| bhyve_config.5 | `usr.sbin/bhyve/bhyve_config.5` | マニュアル | 設定ファイル仕様 |
