# 機能設計書 63-Hyper-Vサポート

## 概要

本ドキュメントは、FreeBSDのMicrosoft Hyper-V仮想環境向け統合サービスの機能設計を記述する。Hyper-Vサポートは、FreeBSDがHyper-Vハイパーバイザ上のゲストOSとして動作する際に必要なドライバ群、VMBus通信基盤、およびホスト連携スクリプトを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Microsoft Hyper-V上でFreeBSDをゲストOSとして効率的に動作させるためには、準仮想化ドライバ（VMBus経由のストレージ、ネットワーク、入力デバイス等）とホストとの連携機能（時刻同期、KVP、ハートビート等）が必要である。これらの統合サービスにより、完全仮想化と比較して大幅なI/O性能向上が実現される。

**機能の利用シーン**：Azure仮想マシンでのFreeBSD運用、オンプレミスHyper-Vサーバ上でのFreeBSDゲスト運用、Windows Server環境でのFreeBSDサーバ仮想化において利用される。

**主要な処理内容**：
1. VMBus仮想バスの初期化とチャネル管理
2. storvsc（仮想SCSIストレージ）ドライバによるディスクI/O
3. hn（仮想ネットワーク）ドライバによるネットワーク通信
4. hv_kbd/hv_hid（仮想入力デバイス）ドライバによる入力処理
5. ホスト連携スクリプト（ネットワーク設定、DNS情報取得、DHCP情報取得）
6. Hyper-V固有のイベントタイマー（vmbus_et）管理
7. SR-IOV VF（Virtual Function）デバイスのアタッチ/デタッチ制御

**関連システム・外部連携**：カーネルのVMBusサブシステム（sys/dev/hyperv/vmbus/）がHyper-Vハイパーバイザとの通信基盤を提供する。ユーザランドスクリプトはdevdイベント経由で呼び出され、ネットワーク設定変更などのホスト側要求に応答する。

**権限による制御**：カーネルドライバはカーネル空間で動作する。ユーザランドスクリプトはroot権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能にはGUI画面の関連はない |

## 機能種別

仮想化統合サービス / デバイスドライバ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ハイパーバイザメッセージ | VMBusメッセージ | Yes | VMBus経由のホストからの要求 | VMBusプロトコル準拠 |
| devdイベント | string | No | デバイスイベント（VFアタッチ等） | devdイベント形式 |

### 入力データソース

- VMBusチャネル: ハイパーバイザとの通信路
- devdイベント: カーネルデバイスイベント
- ホスト側KVP（Key-Value Pair）データ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ディスクI/O応答 | バイト列 | storvscドライバのSCSI応答 |
| ネットワークパケット | バイト列 | hnドライバの送受信パケット |
| ネットワーク設定 | 設定ファイル | hv_set_ifconfigスクリプトの出力 |

### 出力先

- ブロックデバイス: storvscドライバ経由
- ネットワークインタフェース: hnドライバ経由
- /etc/配下の設定ファイル: スクリプト経由

## 処理フロー

### 処理シーケンス

```
1. ハイパーバイザ検出
   └─ CPUID命令によるHyper-V環境の検出
2. VMBus初期化
   └─ VMBus仮想バスの初期化、チャネルオファー受信
3. デバイスドライバ登録
   └─ storvsc、hn、hv_kbd等の各ドライバのVMBusチャネルへのバインド
4. 統合サービス起動
   └─ ハートビート、KVP、時刻同期等のサービスチャネル開設
5. ユーザランドスクリプト配置
   └─ /usr/libexec/hyperv/配下のスクリプトがdevdイベントに応答
6. 通常運用
   └─ 各ドライバがVMBusチャネル経由でI/O処理を実行
```

### フローチャート

```mermaid
flowchart TD
    A[FreeBSDブート] --> B{Hyper-V環境?}
    B -->|Yes| C[VMBus初期化]
    B -->|No| Z[通常ブート継続]
    C --> D[チャネルオファー受信]
    D --> E[storvscドライバ接続]
    D --> F[hnドライバ接続]
    D --> G[統合サービス接続]
    E --> H[ディスクI/O処理]
    F --> I[ネットワーク通信]
    G --> J[ハートビート/KVP/時刻同期]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | ハイパーバイザ検出 | CPUID Leaf 0x40000000でHyper-V署名を検出 | ブート時 |
| BR-63-02 | VMBusバージョンネゴシエーション | ホストとゲスト間でサポートするVMBusプロトコルバージョンを合意 | VMBus初期化時 |
| BR-63-03 | SR-IOV VF制御 | ホストからのVF接続通知に対しhyperv_vfattachスクリプトで対応 | VFデバイス検出時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | VMBus初期化失敗 | ハイパーバイザがVMBusをサポートしない | フォールバック（エミュレーションデバイス使用） |
| - | チャネルオファー失敗 | デバイスが利用不可 | 当該デバイスをスキップ |
| - | VFアタッチ失敗 | SR-IOVデバイスが応答しない | タイムアウト後にリトライ |

### リトライ仕様

VMBusチャネル切断時は自動再接続を試みる。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- 準仮想化ドライバにより、完全仮想化比で大幅なI/O性能向上
- VMBusリングバッファによる効率的なデータ転送

## セキュリティ考慮事項

- VMBus通信はハイパーバイザが仲介するため、ゲスト間の分離はハイパーバイザが保証
- ユーザランドスクリプトはroot権限で実行されるため、スクリプトの改竄に注意

## 備考

- Hyper-Vの統合サービスはLinux IC（Integration Components）と類似の機能をFreeBSDに提供する
- Azure環境ではWALinuxAgent等の追加エージェントが必要な場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | hypervisor.h | `sys/xen/hypervisor.h` | ハイパーバイザ検出の共通インタフェース |
| 1-2 | vmbus.c | `sys/dev/hyperv/vmbus/vmbus.c` | VMBus仮想バスの中核データ構造 |

**読解のコツ**: Hyper-Vサポートはカーネルドライバ（sys/dev/hyperv/）とユーザランドスクリプト（libexec/hyperv/）に分かれる。カーネル側はVMBusバスドライバを中心に理解する。

#### Step 2: VMBusバスドライバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | vmbus.c | `sys/dev/hyperv/vmbus/vmbus.c` | VMBusの初期化、チャネル管理 |
| 2-2 | vmbus_chan.c | `sys/dev/hyperv/vmbus/vmbus_chan.c` | VMBusチャネル操作 |
| 2-3 | vmbus_br.c | `sys/dev/hyperv/vmbus/vmbus_br.c` | リングバッファ管理 |

#### Step 3: デバイスドライバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | hv_storvsc_drv_freebsd.c | `sys/dev/hyperv/storvsc/hv_storvsc_drv_freebsd.c` | 仮想SCSIストレージドライバ |
| 3-2 | hv_kbd.c | `sys/dev/hyperv/input/hv_kbd.c` | 仮想キーボードドライバ |

#### Step 4: ユーザランドスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | hv_set_ifconfig | `contrib/hyperv/tools/scripts/hv_set_ifconfig` | ネットワーク設定スクリプト |
| 4-2 | hv_get_dns_info | `contrib/hyperv/tools/scripts/hv_get_dns_info` | DNS情報取得スクリプト |
| 4-3 | hv_get_dhcp_info | `contrib/hyperv/tools/scripts/hv_get_dhcp_info` | DHCP情報取得スクリプト |
| 4-4 | hyperv_vfattach | `contrib/hyperv/tools/scripts/hyperv_vfattach` | SR-IOV VFアタッチスクリプト |
| 4-5 | hyperv_vfup | `contrib/hyperv/tools/scripts/hyperv_vfup` | SR-IOV VFアップスクリプト |

### プログラム呼び出し階層図

```
Hyper-Vハイパーバイザ
    |
    +-- VMBus [sys/dev/hyperv/vmbus/vmbus.c]
            |
            +-- storvsc [sys/dev/hyperv/storvsc/] → ディスクI/O
            |
            +-- hn [ネットワーク] → ネットワーク通信
            |
            +-- hv_kbd/hv_hid [sys/dev/hyperv/input/] → 入力デバイス
            |
            +-- 統合サービス → ハートビート/KVP/時刻同期

devdイベント
    |
    +-- /usr/libexec/hyperv/hv_set_ifconfig → rc.conf更新
    +-- /usr/libexec/hyperv/hyperv_vfattach → VFデバイス制御
```

### データフロー図

```
[入力]                         [処理]                        [出力]

Hyper-Vホスト ──VMBus──▶ vmbus.c ──────────────▶ 各ドライバ
                          |                          |
チャネルオファー ────────▶ vmbus_chan.c ──▶ storvsc ──▶ ディスクデバイス
                          |                    hn ──▶ ネットワークIF
                          |
devdイベント ────────────▶ libexec/hyperv/* ──▶ 設定ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| vmbus.c | `sys/dev/hyperv/vmbus/vmbus.c` | ソース | VMBusバスドライバ |
| vmbus_chan.c | `sys/dev/hyperv/vmbus/vmbus_chan.c` | ソース | チャネル管理 |
| vmbus_br.c | `sys/dev/hyperv/vmbus/vmbus_br.c` | ソース | リングバッファ |
| vmbus_et.c | `sys/dev/hyperv/vmbus/vmbus_et.c` | ソース | イベントタイマー |
| hyperv.c | `sys/dev/hyperv/vmbus/hyperv.c` | ソース | Hyper-V共通機能 |
| hv_storvsc_drv_freebsd.c | `sys/dev/hyperv/storvsc/hv_storvsc_drv_freebsd.c` | ソース | 仮想SCSIドライバ |
| hv_kbd.c | `sys/dev/hyperv/input/hv_kbd.c` | ソース | 仮想キーボード |
| hv_set_ifconfig | `contrib/hyperv/tools/scripts/hv_set_ifconfig` | スクリプト | ネットワーク設定 |
| hv_get_dns_info | `contrib/hyperv/tools/scripts/hv_get_dns_info` | スクリプト | DNS情報取得 |
| hyperv_vfattach | `contrib/hyperv/tools/scripts/hyperv_vfattach` | スクリプト | VFアタッチ |
| hyperv.conf | `sbin/devd/hyperv.conf` | 設定 | devdイベント設定 |
| Makefile | `libexec/hyperv/Makefile` | ビルド | スクリプトインストール定義 |
