# 機能設計書 64-Xenサポート

## 概要

本ドキュメントは、FreeBSDのXen仮想環境向けドライバおよびサポート機能の設計を記述する。XenサポートはFreeBSDがXenハイパーバイザ上のHVMまたはPVHゲストとして動作するために必要なカーネルインタフェース群を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Xenはオープンソースのハイパーバイザであり、多くのクラウド基盤（AWS EC2等）やエンタープライズ仮想化環境で使用されている。FreeBSDがXen上で効率的に動作するためには、Xenハイパーバイザとの通信インタフェース（ハイパーコール）、イベントチャネル、共有メモリ（Grant Table）、Xenbus/Xenstoreなどの準仮想化基盤が必要である。

**機能の利用シーン**：AWS EC2インスタンスでのFreeBSD運用、Xen Serverによる仮想化環境でのFreeBSDゲスト運用、Citrix Hypervisor上でのFreeBSDゲスト動作に利用される。

**主要な処理内容**：
1. Xenドメイン環境の検出とハイパーバイザ情報取得
2. 共有情報ページ（shared_info）のマッピングとvCPU情報の設定
3. イベントチャネル（evtchn）の初期化と割り込みルーティング
4. Grant Table（gntdev/gnttab）によるドメイン間共有メモリ管理
5. Xenbus/Xenstoreによるデバイス構成情報の取得・設定
6. メモリバルーンドライバ（xenmem）による動的メモリ管理

**関連システム・外部連携**：Xenハイパーバイザとのインタフェースはハイパーコールを通じて行われる。Xenstoreデーモンは構成情報の分散データベースとして機能し、ゲストとdom0間の通信に使用される。

**権限による制御**：すべてのXen関連機能はカーネル空間で動作する。特権ドメイン（dom0）と非特権ドメイン（domU）では利用可能なハイパーコールが異なる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能にはGUI画面の関連はない |

## 機能種別

仮想化準仮想化ドライバ / カーネルサブシステム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ハイパーコール応答 | 構造体 | Yes | Xenハイパーバイザからの応答データ | プロトコル準拠 |
| Xenstore値 | string | No | 構成情報のキー・バリュー | Xenstoreパス形式 |

### 入力データソース

- Xenハイパーコールインタフェース
- Xenstore（分散構成データベース）
- 共有情報ページ（shared_info_t）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ハイパーコール要求 | 構造体 | Xenハイパーバイザへの要求 |
| イベント通知 | int | イベントチャネル経由の割り込み |
| Grant参照 | grant_ref_t | 共有メモリ参照 |

### 出力先

- Xenハイパーバイザ: ハイパーコール経由
- イベントチャネル: 割り込み経由
- Xenstore: 構成情報更新

## 処理フロー

### 処理シーケンス

```
1. Xenドメイン検出
   └─ CPUID命令によるXenハイパーバイザ検出、HVM/PVH判定
2. 共有情報ページマッピング
   └─ HYPERVISOR_shared_infoのマッピング
3. vCPU情報設定
   └─ 各vCPU用のvcpu_info構造体を登録（xen_setup_vcpu_info）
4. イベントチャネル初期化
   └─ evtchnの初期化、割り込みルーティング設定
5. Grant Table初期化
   └─ gnttabインタフェースの初期化
6. Xenbus接続
   └─ Xenstoreとの通信路確立
7. デバイス列挙
   └─ Xenbus経由でバックエンドデバイスを検出・初期化
```

### フローチャート

```mermaid
flowchart TD
    A[FreeBSDブート] --> B{Xenドメイン?}
    B -->|Yes| C[shared_infoマッピング]
    B -->|No| Z[通常ブート]
    C --> D[vCPU情報設定]
    D --> E[イベントチャネル初期化]
    E --> F[Grant Table初期化]
    F --> G[Xenbus接続]
    G --> H[デバイス列挙・初期化]
    H --> I[通常運用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-64-01 | ドメイン種別判定 | hvm_start_flagsによりPVHv2初期ドメインかHVMゲストかを判定 | ブート時 |
| BR-64-02 | vCPU情報登録 | vcpu_info構造体は64バイト境界にアラインメントされること | vCPU初期化時 |
| BR-64-03 | ハイパーコール制限 | domUでは特権ハイパーコール呼び出し不可 | 非特権ドメイン時 |

### 計算ロジック

vCPU情報のMFN計算: `mfn = vtophys(vcpu_info) >> PAGE_SHIFT`
オフセット計算: `offset = vtophys(vcpu_info) & PAGE_MASK`

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。Xenstoreが分散構成データベースとして機能するが、従来のRDBMSではない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | Xenstoreパス不在 | 要求した構成情報が存在しない | デフォルト値使用またはスキップ |
| - | ハイパーコール失敗 | 無効な操作または権限不足 | エラーコードに基づく処理分岐 |
| - | vCPU登録失敗 | ハイパーバイザがvCPU情報登録を拒否 | shared_infoからのフォールバック |

### リトライ仕様

Xenstore接続の一時的切断時は自動再接続を試みる。

## トランザクション仕様

Xenstoreトランザクションにより、複数のキー・バリュー操作をアトミックに実行可能。

## パフォーマンス要件

- 準仮想化割り込みによる低レイテンシのイベント通知
- Grant Tableによるゼロコピーのドメイン間データ転送

## セキュリティ考慮事項

- ドメイン間分離はXenハイパーバイザが保証
- Grant Tableによる共有メモリは明示的な許可なしにはアクセス不可
- 特権ドメイン操作はdom0に限定

## 備考

- FreeBSDのXenサポートはHVMおよびPVHv2モードを対象とし、旧来のPVモードは非対応
- sys/xen/ディレクトリにはXenハイパーバイザインタフェースの共通コードが含まれる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | xen-os.h | `sys/xen/xen-os.h` | Xenドメイン判定マクロ（xen_domain()等） |
| 1-2 | hvm.h | `sys/xen/hvm.h` | HVM固有の定義 |
| 1-3 | hypervisor.h | `sys/xen/hypervisor.h` | ハイパーバイザ共有情報ポインタ |

**読解のコツ**: sys/xen/内のヘッダファイルはcontrib/xen/からインポートされたXen公式ヘッダを参照する場合がある。FreeBSD固有の適応層とXen公式定義の区別に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | xen_common.c | `sys/xen/xen_common.c` | Xen共通初期化コード |

**主要処理フロー**:
1. **48行目**: hvm_start_flags - PVHv2初期ドメインフラグ
2. **51行目**: HYPERVISOR_shared_info - 共有情報ページポインタ
3. **54行目**: DPCPU_DEFINE(vcpu_info) - per-CPU vCPU情報
4. **56-96行目**: xen_setup_vcpu_info() - vCPU情報の登録処理
5. **73-74行目**: vcpu_info構造体の64バイトアラインメント検証

#### Step 3: イベントチャネルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | evtchn.h | `sys/xen/evtchn.h` | イベントチャネルインタフェース |
| 3-2 | evtchn/ | `sys/xen/evtchn/` | イベントチャネル実装 |

#### Step 4: Xenbusを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | xenbus/ | `sys/xen/xenbus/` | Xenbusドライバフレームワーク |
| 4-2 | xenstore/ | `sys/xen/xenstore/` | Xenstore通信 |

### プログラム呼び出し階層図

```
FreeBSDカーネル初期化
    |
    +-- Xenドメイン検出 (CPUID)
    |
    +-- xen_common.c
    |       +-- xen_setup_vcpu_info() [56-96行目]
    |               +-- HYPERVISOR_vcpu_op(VCPUOP_register_vcpu_info)
    |
    +-- evtchn初期化
    |       +-- イベントチャネル割り込み設定
    |
    +-- xenbus初期化
    |       +-- Xenstore接続
    |       +-- デバイス列挙
    |
    +-- xenmem初期化
            +-- メモリバルーン制御
```

### データフロー図

```
[入力]                      [処理]                        [出力]

Xenハイパーバイザ ──▶ ハイパーコール処理 ──▶ カーネル状態更新
shared_info ──────▶ xen_common.c ────────▶ vcpu_info設定
Xenstore ─────────▶ xenbus/ ──────────────▶ デバイス構成
イベントチャネル ──▶ evtchn/ ──────────────▶ 割り込み配信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| xen_common.c | `sys/xen/xen_common.c` | ソース | 共通初期化コード |
| xen-os.h | `sys/xen/xen-os.h` | ヘッダ | OS依存定義 |
| hvm.h | `sys/xen/hvm.h` | ヘッダ | HVM固有定義 |
| hypervisor.h | `sys/xen/hypervisor.h` | ヘッダ | ハイパーバイザインタフェース |
| evtchn.h | `sys/xen/evtchn.h` | ヘッダ | イベントチャネル定義 |
| features.c | `sys/xen/features.c` | ソース | Xen機能検出 |
| features.h | `sys/xen/features.h` | ヘッダ | 機能フラグ定義 |
| xen_intr.h | `sys/xen/xen_intr.h` | ヘッダ | Xen割り込み定義 |
| blkif.h | `sys/xen/blkif.h` | ヘッダ | ブロックデバイスインタフェース |
| gntdev.h | `sys/xen/gntdev.h` | ヘッダ | Grantデバイスインタフェース |
| gnttab.h | `sys/xen/gnttab.h` | ヘッダ | Grant Tableインタフェース |
