# 機能設計書 73-ユーザ・グループ管理

## 概要

本ドキュメントは、FreeBSDのユーザアカウントおよびグループの管理機能について記述する。pw(8)コマンドを中核として、adduser(8)、rmuser(8)、chpass(1)などのユーティリティにより、システム上のユーザ・グループの作成・変更・削除・表示を行う。

### 本機能の処理概要

**業務上の目的・背景**：マルチユーザシステムであるFreeBSDでは、ユーザアカウントとグループの適切な管理がシステムセキュリティとリソース管理の基盤となる。管理者はユーザの追加・削除・属性変更、グループの管理を通じてアクセス制御を実現する。

**機能の利用シーン**：新規ユーザアカウントの作成（adduser/pw useradd）、ユーザ削除（rmuser/pw userdel）、パスワード変更（chpass）、グループへのユーザ追加（pw groupmod）、ユーザ情報の表示（pw usershow）、インストール時のrootパスワード設定やユーザ追加。

**主要な処理内容**：
1. pw(8): ユーザ・グループのCRUD操作の統合コマンド（useradd/userdel/usermod/usershow/groupadd/groupdel/groupmod/groupshow/lock/unlock）
2. adduser(8): 対話的なユーザアカウント作成シェルスクリプト
3. rmuser(8): ユーザアカウントの完全削除シェルスクリプト（ホームディレクトリ・crontab等含む）
4. chpass(1): ユーザ情報（シェル、名前、パスワード等）の変更

**関連システム・外部連携**：/etc/passwd、/etc/master.passwd、/etc/group、/etc/pw.confの読み書き。NIS対応（pw_nis.c）。bsdinstallからの呼び出し（インストール時のユーザ設定）。

**権限による制御**：pw(8)はroot権限が必要。chpass(1)は自分自身の情報変更は一般ユーザでも可能だが、他ユーザの変更にはroot権限が必要。adduser/rmuserはroot権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | rootパスワード設定画面 | 主機能 | pwコマンドによるrootユーザパスワードの設定処理 |
| 28 | ユーザ追加確認画面 | 主機能 | ユーザアカウント追加の実行有無を確認するYes/Noダイアログ |
| 29 | ユーザ追加画面 | 主機能 | chroot環境内でのadduserコマンドによる対話的ユーザアカウント作成 |
| 30 | 最終設定メニュー画面 | 遷移先機能 | Add User選択時のadduser画面への遷移 |

## 機能種別

CRUD操作 / ユーザ管理

## 入力仕様

### 入力パラメータ（pw useradd）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -n name | 文字列 | Yes | ユーザ名 | 重複チェック、文字種チェック |
| -u uid | 整数 | No | UID（省略時は自動採番） | 0以上、重複チェック |
| -g group | 文字列 | No | プライマリグループ | 存在するグループ名またはGID |
| -G groups | 文字列 | No | 追加グループ（カンマ区切り） | 存在するグループ名 |
| -c comment | 文字列 | No | GECOSフィールド（フルネーム等） | なし |
| -d home | 文字列 | No | ホームディレクトリ | パス形式 |
| -s shell | 文字列 | No | ログインシェル | /etc/shellsに登録されたシェル |
| -m | フラグ | No | ホームディレクトリを作成 | なし |
| -k skeldir | 文字列 | No | スケルトンディレクトリ | 存在するディレクトリ |
| -w method | 文字列 | No | パスワード設定方法（no/yes/none/random） | 有効な方法名 |
| -e expiry | 文字列 | No | アカウント有効期限 | 日付形式 |
| -p period | 文字列 | No | パスワード有効期限 | 日付形式 |

### 入力データソース

- コマンドライン引数
- /etc/pw.conf（pwコマンドのデフォルト値設定）
- /etc/passwd、/etc/master.passwd、/etc/group（既存アカウント情報）
- 標準入力（adduser対話入力）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| /etc/passwd | ファイル | ユーザアカウント情報（公開用） |
| /etc/master.passwd | ファイル | ユーザアカウント情報（パスワードハッシュ含む） |
| /etc/group | ファイル | グループ情報 |
| /etc/pwd.db | データベース | passwd.dbバイナリデータベース |
| /etc/spwd.db | データベース | セキュアpasswd.dbバイナリデータベース |
| ホームディレクトリ | ディレクトリ | -m指定時に作成 |

### 出力先

- /etc/passwd、/etc/master.passwd、/etc/group（テキストファイル）
- /etc/pwd.db、/etc/spwd.db（バイナリデータベース）
- ユーザのホームディレクトリ（-m指定時）
- 標準出力（usershow/groupshow時の情報表示）

## 処理フロー

### 処理シーケンス

```
pw useradd:
1. コマンドライン引数解析
   └─ モード（add/del/mod/show）とターゲット（user/group）の判定
2. 設定ファイル読み込み
   └─ /etc/pw.confからデフォルト値を取得
3. UID採番
   └─ 指定なしの場合、使用可能な最小UIDを自動採番
4. パスワードデータベースロック
   └─ pw_lock()による排他制御
5. master.passwdエントリ作成
   └─ ユーザ情報をmaster.passwd形式で構築
6. パスワード設定
   └─ -wオプションに応じたパスワード設定（ハッシュ化含む）
7. グループエントリ更新
   └─ プライマリグループ・追加グループへの所属設定
8. ホームディレクトリ作成
   └─ -m指定時にスケルトンからコピー
9. データベース再構築
   └─ pwd_mkdb(8)によるpwd.db/spwd.dbの再構築
10. ログ記録
    └─ ユーザ作成の監査ログ
```

### フローチャート

```mermaid
flowchart TD
    A[pw コマンド起動] --> B[モード・ターゲット判定]
    B --> C{user or group?}
    C -->|user| D{操作種別}
    C -->|group| E{操作種別}
    D -->|add| F[pw_user_add]
    D -->|del| G[pw_user_del]
    D -->|mod| H[pw_user_mod]
    D -->|show| I[pw_user_show]
    D -->|lock/unlock| J[pw_user_lock/unlock]
    E -->|add| K[pw_group_add]
    E -->|del| L[pw_group_del]
    E -->|mod| M[pw_group_mod]
    E -->|show| N[pw_group_show]
    F --> O[UID採番]
    O --> P[master.passwd更新]
    P --> Q[group更新]
    Q --> R{-m指定?}
    R -->|Yes| S[ホームディレクトリ作成]
    R -->|No| T[pwd_mkdb実行]
    S --> T
    T --> U[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-73-01 | UID一意性 | UIDはシステム内で一意でなければならない（-oオプションで重複許可可能） | useradd/usermod時 |
| BR-73-02 | UID自動採番 | UID未指定時はuid_minからuid_maxの範囲で未使用の最小値を採番 | useradd時にUID未指定 |
| BR-73-03 | ユーザ名制約 | ユーザ名は英数字・ハイフン・アンダースコアで構成、先頭は英字 | useradd/usermod時 |
| BR-73-04 | パスワードハッシュ | パスワードはcrypt(3)によりハッシュ化して保存 | パスワード設定時 |
| BR-73-05 | ホームディレクトリコピー | -m指定時は/usr/share/skel（デフォルト）からファイルをコピー | useradd -m時 |

### 計算ロジック

- UID自動採番: pw.confで定義されたuid_minからuid_maxの範囲で、passwd DBに存在しない最小のUIDを選択する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| useradd | /etc/master.passwd | INSERT | ユーザエントリの追加 |
| useradd | /etc/group | UPDATE | グループメンバーシップの追加 |
| userdel | /etc/master.passwd | DELETE | ユーザエントリの削除 |
| userdel | /etc/group | UPDATE | グループメンバーシップの削除 |
| usermod | /etc/master.passwd | UPDATE | ユーザ属性の変更 |
| groupadd | /etc/group | INSERT | グループエントリの追加 |
| groupdel | /etc/group | DELETE | グループエントリの削除 |

### テーブル別操作詳細

#### /etc/master.passwd

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name:password:uid:gid:class:change:expire:gecos:home:shell | 各フィールドにコマンドライン引数の値 | pwd_mkdb(8)でDBに変換 |
| UPDATE | 指定フィールド | -n/-u/-g/-c/-d/-s等で指定された値 | 変更対象フィールドのみ更新 |
| DELETE | 行全体 | ユーザ名またはUIDで特定 | 関連グループからも削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EX_USAGE | 使用法エラー | 必須パラメータ未指定 | usage表示 |
| EX_OSFILE | ファイルエラー | /etc/passwdアクセス不可 | エラーメッセージ出力 |
| EXIT_FAILURE | 一般エラー | UID重複、ユーザ名重複 | エラーメッセージ出力 |
| EXIT_FAILURE | 権限エラー | root権限なし | エラーメッセージ出力 |

### リトライ仕様

リトライは行わない。パスワードデータベースのロック取得に失敗した場合はエラー終了する。

## トランザクション仕様

パスワードデータベースの更新はpw_lock()によるファイルロックで排他制御される。master.passwdの更新後、pwd_mkdb(8)によりバイナリDBが再構築される。この間はアトミックではないため、中断時にはデータベースの不整合が発生する可能性がある。

## パフォーマンス要件

特になし。ユーザ管理操作は対話的に行われる低頻度の操作である。

## セキュリティ考慮事項

- master.passwdはパーミッション0600（rootのみ読み書き可能）
- spwd.dbもパーミッション0600で保護
- パスワードはcrypt(3)によるハッシュ保存（平文保存は行わない）
- pw user lockによるアカウントロック機能（パスワードフィールドに"*LOCKED*"プレフィックス）
- chpass(1)は自分自身の情報変更時でも、シェル変更は/etc/shellsの制約を受ける

## 備考

- pw(8)はFreeBSD固有のユーザ管理ツールであり、他のBSD系OSには存在しない
- adduserはシェルスクリプト（adduser.sh）として実装されており、内部でpw(8)を呼び出す
- -Vオプションで代替ディレクトリ指定、-Rオプションでchroot先のユーザ管理が可能（bsdinstallで利用）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pw.c | `usr.sbin/pw/pw.c` | pwf構造体（パスワードファイルアクセス関数群）、Modes/Which配列（操作モード定義）、cmdfunc関数テーブルを理解する |

**読解のコツ**: pw.cはコマンドディスパッチャとして機能する。cmdfunc[which][mode]の2次元関数テーブルにより、"user add" -> pw_user_add()のようにディスパッチされる。PWF構造体はsetpwent/getpwent等の関数ポインタを保持し、-V/-Rオプション時にVPWF（代替ディレクトリ用）に切り替える。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pw.c | `usr.sbin/pw/pw.c` | main関数: コマンドライン解析でmode/whichを決定し、cmdfunc[which][mode]を呼び出す流れを理解する |

**主要処理フロー**:
1. **38-51行目**: Modes配列（"add","del","mod","show","next"）とCombo1/Combo2（ "useradd","groupdel"等の省略形）の定義
2. **53-81行目**: PWF/VPWF構造体の初期化（通常のpasswd関数群と代替ディレクトリ用関数群）
3. **83-100行目**: cmdfunc関数テーブル（pw_user_add, pw_user_del等の関数ポインタ配列）
4. **111-224行目**: main関数でのモード/ターゲット判定と-V/-R/-Mオプションの処理

#### Step 3: ユーザ操作の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pw_user.c | `usr.sbin/pw/pw_user.c` | pw_user_add/pw_user_del/pw_user_mod/pw_user_show関数の実装を理解する |
| 3-2 | pw_group.c | `usr.sbin/pw/pw_group.c` | pw_group_add等のグループ操作関数の実装を理解する |
| 3-3 | pw_conf.c | `usr.sbin/pw/pw_conf.c` | /etc/pw.confの読み込みとデフォルト値管理を理解する |
| 3-4 | cpdir.c | `usr.sbin/pw/cpdir.c` | ホームディレクトリのスケルトンコピー処理を理解する |

#### Step 4: 対話的ユーザ管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | adduser.sh | `usr.sbin/adduser/adduser.sh` | 対話的ユーザ作成スクリプトの流れ（pw useraddの呼び出し方）を理解する |
| 4-2 | rmuser.sh | `usr.sbin/adduser/rmuser.sh` | ユーザ削除スクリプトの流れ（ホームディレクトリ・crontab削除等）を理解する |

### プログラム呼び出し階層図

```
pw (usr.sbin/pw/pw.c)
    |
    +-- main()
          +-- getindex() / コマンドディスパッチ
          +-- cmdfunc[which][mode]()
                |
                +-- pw_user_add() [pw_user.c]
                |     +-- pw_conf読み込み
                |     +-- UID採番
                |     +-- master.passwd更新
                |     +-- group更新
                |     +-- cpdir() [cpdir.c] # ホームディレクトリコピー
                |     +-- pwd_mkdb(8) 呼び出し
                |
                +-- pw_user_del() [pw_user.c]
                +-- pw_user_mod() [pw_user.c]
                +-- pw_user_show() [pw_user.c]
                +-- pw_user_lock/unlock() [pw_user.c]
                +-- pw_group_add/del/mod/show() [pw_group.c]

adduser (usr.sbin/adduser/adduser.sh)
    |
    +-- 対話入力
    +-- pw useradd 呼び出し

chpass (usr.bin/chpass/)
    |
    +-- main() [chpass.c]
          +-- edit() [edit.c]
          +-- field処理 [field.c]
```

### データフロー図

```
[入力]                      [処理]                        [出力]

コマンドライン引数     pw_user_add():                  /etc/master.passwd
(ユーザ名,UID等) --> UID採番 --> エントリ構築      --> (更新)
                       |                                /etc/passwd
/etc/pw.conf     --> デフォルト値取得                --> (更新)
(設定ファイル)          |                                /etc/group
                       +-- グループ更新              --> (更新)
/usr/share/skel  --> ホームディレクトリコピー        --> ~/（ホームディレクトリ）
(スケルトン)            |
                       +-- pwd_mkdb(8)              --> /etc/pwd.db
                                                    --> /etc/spwd.db
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pw.c | `usr.sbin/pw/pw.c` | ソース | pwコマンドのエントリーポイント・ディスパッチャ |
| pw_user.c | `usr.sbin/pw/pw_user.c` | ソース | ユーザ操作（add/del/mod/show/lock/unlock）の実装 |
| pw_group.c | `usr.sbin/pw/pw_group.c` | ソース | グループ操作（add/del/mod/show）の実装 |
| pw_conf.c | `usr.sbin/pw/pw_conf.c` | ソース | pw.conf読み込み・デフォルト値管理 |
| cpdir.c | `usr.sbin/pw/cpdir.c` | ソース | ホームディレクトリのスケルトンコピー |
| pw_log.c | `usr.sbin/pw/pw_log.c` | ソース | 監査ログ記録 |
| pw_nis.c | `usr.sbin/pw/pw_nis.c` | ソース | NIS対応処理 |
| pw_vpw.c | `usr.sbin/pw/pw_vpw.c` | ソース | 代替ディレクトリ用passwd関数群 |
| pw_utils.c | `usr.sbin/pw/pw_utils.c` | ソース | ユーティリティ関数群 |
| adduser.sh | `usr.sbin/adduser/adduser.sh` | スクリプト | 対話的ユーザ作成スクリプト |
| rmuser.sh | `usr.sbin/adduser/rmuser.sh` | スクリプト | ユーザ削除スクリプト |
| chpass.c | `usr.bin/chpass/chpass.c` | ソース | chpassコマンドのメイン処理 |
| edit.c | `usr.bin/chpass/edit.c` | ソース | ユーザ情報編集処理 |
| field.c | `usr.bin/chpass/field.c` | ソース | フィールド定義・バリデーション |
| pw.8 | `usr.sbin/pw/pw.8` | マニュアル | pwコマンドのmanページ |
