# 機能設計書 74-パッケージ管理支援

## 概要

本ドキュメントは、FreeBSDのシステム設定・インストール支援ツール群（bsdinstall、bsdconfig）の機能設計について記述する。bsdinstallはFreeBSDの対話的インストーラとして、ディスクパーティション設定からパッケージインストール、ユーザ設定まで一連のインストール作業を自動化する。bsdconfigはインストール後のシステム設定変更を支援する管理ツールである。

### 本機能の処理概要

**業務上の目的・背景**：FreeBSDのインストール・初期設定作業を効率的かつ確実に行うための対話的ツールが必要である。bsdinstallは新規インストール時に、ディスク設定からネットワーク設定、ユーザ作成まで一連の工程をガイドし、管理者の負担を軽減する。bsdconfigはインストール後のシステム設定変更を提供する。

**機能の利用シーン**：FreeBSDの新規インストール時（bsdinstall）、インストール後のシステム設定変更時（bsdconfig）、自動インストールスクリプトの実行時（bsdinstall script）。

**主要な処理内容**：
1. bsdinstall: キーマップ選択、ホスト名設定、配布セット選択、ネットワーク設定、ディスクパーティション、配布ファイルのダウンロード・展開、rootパスワード設定、タイムゾーン設定、サービス設定、セキュリティ強化設定、ユーザ追加
2. bsdconfig: コンソール設定、ディスク管理、ドキュメントインストール、マウス設定、ネットワーク設定、パッケージ管理、パスワード変更、セキュリティ設定、スタートアップ設定、タイムゾーン設定、TTY設定、ユーザ管理
3. チェックサム検証: sha256による配布ファイルの整合性検証
4. 配布ファイル展開: libarchiveによるtar.xzファイルの展開

**関連システム・外部連携**：dialog(1)による対話的UI、pkg(8)によるパッケージインストール、ifconfig(8)によるネットワーク設定、pw(8)によるユーザ管理、tzsetup(8)によるタイムゾーン設定、ZFS/UFSファイルシステムツール、libfetch(3)による配布ファイルダウンロード。

**権限による制御**：bsdinstallはroot権限で実行される。インストール先のchroot環境内で各種設定コマンドが実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | キーマップ選択画面 | 主機能 | bsdinstallフレームワークによるキーボードレイアウト選択 |
| 2 | ホスト名設定画面 | 主機能 | ホスト名入力・rc.confへの保存処理 |
| 3 | インストール種別選択画面 | 主機能 | Distribution Sets / Packagesの選択判定 |
| 4 | ネットワーク/オフラインインストール選択画面 | 主機能 | ネットワーク/オフラインモード選択 |
| 5 | 配布セット選択画面 | 主機能 | MANIFESTからオプション配布セット解析 |
| 13 | ミラーサイト選択画面 | 補助機能 | リリースバージョンに基づくURL生成 |
| 18 | 配布ファイルダウンロード画面 | 補助機能 | 配布ファイルURL解決とダウンロード先管理 |
| 19 | チェックサム検証画面 | 主機能 | sha256による配布ファイルチェックサム検証 |
| 20 | 配布ファイル展開画面 | 補助機能 | 展開先ディレクトリ管理とDISTRIBUTIONS変数処理 |
| 30 | 最終設定メニュー画面 | 主機能 | インストール完了前の各種設定再変更メニュー |
| 31 | ドキュメントインストール画面 | 主機能 | pkg installによるドキュメントパッケージインストール |
| 32 | 手動設定確認画面 | 主機能 | chroot環境シェル起動確認 |
| 33 | インストール中断エラー画面 | 主機能 | インストールステップ中断時のリスタート/終了選択 |

## 機能種別

インストール支援 / システム設定 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| BSDINSTALL_DISTDIR | 環境変数 | No | 配布ファイル格納ディレクトリ | ディレクトリパス |
| BSDINSTALL_DISTSITE | 環境変数 | No | 配布ファイルダウンロードURL | URL形式 |
| BSDINSTALL_CHROOT | 環境変数 | No | インストール先ルート | ディレクトリパス |
| DISTRIBUTIONS | 環境変数 | No | インストールする配布セット | スペース区切りリスト |
| BSDINSTALL_TMPETC | 環境変数 | No | 一時設定ファイルディレクトリ | ディレクトリパス |

### 入力データソース

- dialog(1)を使用した対話的UI入力
- 環境変数（スクリプトモード時）
- MANIFEST ファイル（配布セット一覧）
- rc.conf、resolv.conf等の設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| /etc/rc.conf | ファイル | システム起動設定（ホスト名、サービス、ネットワーク等） |
| /etc/resolv.conf | ファイル | DNS設定 |
| /etc/localtime | リンク | タイムゾーン設定 |
| /etc/sysctl.conf | ファイル | カーネルパラメータ設定 |
| /boot/loader.conf | ファイル | ブートローダ設定 |
| ファイルシステム | ディスク | パーティション・ファイルシステムの作成 |

### 出力先

- インストール先ルートファイルシステム（BSDINSTALL_CHROOT以下）
- dialog(1)による画面出力

## 処理フロー

### 処理シーケンス

```
bsdinstall:
1. 初期化
   └─ 環境変数設定、dialog初期化
2. キーマップ選択
   └─ キーボードレイアウトの選択・テスト
3. ホスト名設定
   └─ ホスト名入力とrc.confへの保存
4. インストール種別選択
   └─ Distribution Sets / Packages選択
5. 配布セット選択
   └─ MANIFEST解析、チェックリスト表示
6. ネットワーク設定（必要時）
   └─ インタフェース選択、IPv4/IPv6設定、DNS設定
7. ミラーサイト選択（ネットワークインストール時）
   └─ ダウンロードURL設定
8. パーティション設定
   └─ Auto(ZFS)/Auto(UFS)/Manual/Shell
9. 配布ファイルダウンロード
   └─ libfetchによるダウンロード・進捗表示
10. チェックサム検証
    └─ sha256による整合性検証
11. 配布ファイル展開
    └─ libarchiveによる展開・進捗表示
12. 基本設定
    └─ rootパスワード、タイムゾーン、サービス、セキュリティ
13. ユーザ追加
    └─ adduser対話
14. 最終設定
    └─ 各種設定の再変更メニュー
15. 完了
    └─ chroot環境シェル提供（オプション）
```

### フローチャート

```mermaid
flowchart TD
    A[bsdinstall起動] --> B[キーマップ選択]
    B --> C[ホスト名設定]
    C --> D[配布セット選択]
    D --> E{ネットワーク必要?}
    E -->|Yes| F[ネットワーク設定]
    E -->|No| G[パーティション設定]
    F --> H[ミラーサイト選択]
    H --> G
    G --> I[配布ファイルダウンロード]
    I --> J[チェックサム検証]
    J --> K[配布ファイル展開]
    K --> L[rootパスワード設定]
    L --> M[タイムゾーン設定]
    M --> N[サービス設定]
    N --> O[セキュリティ強化設定]
    O --> P[ユーザ追加]
    P --> Q[最終設定メニュー]
    Q --> R[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-01 | チェックサム必須検証 | ダウンロードした配布ファイルはsha256チェックサムで整合性を検証する | 配布ファイルダウンロード後 |
| BR-74-02 | MANIFEST解析 | 配布セット一覧はMANIFESTファイルから動的に取得する | 配布セット選択時 |
| BR-74-03 | chroot環境 | インストール先への設定はchroot環境内で実行される | 設定コマンド実行時 |
| BR-74-04 | noshutdown保護 | インストール中は/var/run/noshutdownが存在する場合でも処理を継続 | インストール実行中 |

### 計算ロジック

- ダウンロードURL生成: リリースバージョンとアーキテクチャからミラーサイトURLを構築（BSDINSTALL_DISTSITE変数）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベースは使用しない |

### テーブル別操作詳細

該当なし。設定はテキストファイルベースで行われる。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ダウンロード失敗 | ネットワーク接続不可、URL無効 | リトライまたはミラーサイト変更 |
| - | チェックサム不一致 | ファイル破損、不正ファイル | 再ダウンロード |
| - | 展開失敗 | ディスク容量不足 | エラー表示、リスタート選択 |
| - | パーティション作成失敗 | ディスクアクセスエラー | エラー表示、手動パーティション選択 |

### リトライ仕様

配布ファイルのダウンロード失敗時は、ユーザに再ダウンロードまたはミラーサイト変更の選択を提示する。

## トランザクション仕様

bsdinstallの各ステップは独立しており、ステップ間のトランザクション制御は行われない。中断時はインストール中断エラー画面（画面33）でリスタートまたは終了を選択可能。

## パフォーマンス要件

- 配布ファイルのダウンロード・展開中は進捗表示（dialog gauge widget使用）
- 大容量配布セットの展開にはディスクI/Oがボトルネックとなる

## セキュリティ考慮事項

- sha256チェックサムによる配布ファイルの整合性検証
- rootパスワードの設定はpw(8)を使用して安全に行われる
- セキュリティ強化設定画面でMACポリシー、sysctlパラメータの設定が可能
- インストール中はchroot環境内で操作が行われ、ホストシステムへの影響を最小化

## 備考

- bsdinstallはシェルスクリプトベースのモジュラーアーキテクチャで、各ステップがscripts/ディレクトリ内の個別スクリプトとして実装されている
- bsdconfigはSysinstallの後継として、dialog(1)ベースの設定管理UIを提供する
- スクリプトモード（bsdinstall script）により、自動インストールが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bsdinstall | `usr.sbin/bsdinstall/bsdinstall` | メインスクリプト。BSDINSTALL_*環境変数の定義と各ステップの呼び出し順序を理解する |

**読解のコツ**: bsdinstallはシェルスクリプトベースのフレームワークで、各インストールステップはscripts/ディレクトリ内の個別スクリプトとして実装されている。環境変数がステップ間のデータ受け渡しに使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | startbsdinstall | `usr.sbin/bsdinstall/startbsdinstall` | インストーラの起動スクリプトを理解する |
| 2-2 | scripts/ | `usr.sbin/bsdinstall/scripts/` | 各インストールステップのスクリプト群を確認する |

#### Step 3: 各ステップの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | distfetch/ | `usr.sbin/bsdinstall/distfetch/` | 配布ファイルダウンロード処理（C言語実装） |
| 3-2 | distextract/ | `usr.sbin/bsdinstall/distextract/` | 配布ファイル展開処理（C言語実装） |
| 3-3 | partedit/ | `usr.sbin/bsdinstall/partedit/` | パーティション編集処理（C言語実装） |

#### Step 4: bsdconfigの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | bsdconfig | `usr.sbin/bsdconfig/bsdconfig` | bsdconfigメインスクリプトの構造を理解する |
| 4-2 | share/ | `usr.sbin/bsdconfig/share/` | 共有ライブラリスクリプト群 |

### プログラム呼び出し階層図

```
bsdinstall (usr.sbin/bsdinstall/bsdinstall)
    |
    +-- scripts/keymap          # キーマップ選択
    +-- scripts/hostname        # ホスト名設定
    +-- scripts/fetchmissingdists # 配布ファイル取得
    |     +-- distfetch/        # C言語ダウンロードプログラム
    +-- scripts/checksum        # チェックサム検証
    +-- distextract/            # C言語展開プログラム
    +-- scripts/rootpass        # rootパスワード設定
    |     +-- pw(8)             # パスワード変更
    +-- scripts/timezone        # タイムゾーン設定
    |     +-- tzsetup(8)
    +-- scripts/services        # サービス設定
    +-- scripts/hardening       # セキュリティ強化
    +-- scripts/adduser         # ユーザ追加
    |     +-- adduser(8)
    +-- scripts/finalconfig     # 最終設定メニュー

bsdconfig (usr.sbin/bsdconfig/bsdconfig)
    |
    +-- console/                # コンソール設定
    +-- diskmgmt/               # ディスク管理
    +-- networking/             # ネットワーク設定
    +-- packages/               # パッケージ管理
    +-- password/               # パスワード変更
    +-- security/               # セキュリティ設定
    +-- startup/                # スタートアップ設定
    +-- timezone/               # タイムゾーン設定
    +-- usermgmt/               # ユーザ管理
```

### データフロー図

```
[入力]                      [処理]                        [出力]

dialog対話入力         bsdinstallフレームワーク:        ファイルシステム
(ユーザ選択) -------> scripts/* (各ステップ)      ---> (パーティション/FS)
                       |
環境変数            distfetch (C言語)               /etc/rc.conf
(BSDINSTALL_*) ---> ダウンロード・展開           ---> (システム設定)
                       |
MANIFESTファイル     distextract (C言語)             /etc/resolv.conf
(配布セット一覧) --> libarchive展開              ---> (DNS設定)
                       |
ミラーサイトURL       partedit (C言語)               BSDINSTALL_CHROOT/
(DISTSITE) -------> libfetchダウンロード         ---> (インストール先)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bsdinstall | `usr.sbin/bsdinstall/bsdinstall` | スクリプト | メインインストーラスクリプト |
| startbsdinstall | `usr.sbin/bsdinstall/startbsdinstall` | スクリプト | インストーラ起動スクリプト |
| scripts/ | `usr.sbin/bsdinstall/scripts/` | スクリプト | 各インストールステップのスクリプト群 |
| distfetch/ | `usr.sbin/bsdinstall/distfetch/` | ソース | 配布ファイルダウンロード（C言語） |
| distextract/ | `usr.sbin/bsdinstall/distextract/` | ソース | 配布ファイル展開（C言語） |
| partedit/ | `usr.sbin/bsdinstall/partedit/` | ソース | パーティション編集（C言語） |
| runconsoles | `usr.sbin/bsdinstall/runconsoles` | スクリプト | マルチコンソール対応 |
| include/ | `usr.sbin/bsdinstall/include/` | ヘッダ | 共通ヘッダファイル |
| bsdinstall.8 | `usr.sbin/bsdinstall/bsdinstall.8` | マニュアル | bsdinstallコマンドのmanページ |
| bsdconfig | `usr.sbin/bsdconfig/bsdconfig` | スクリプト | bsdconfigメインスクリプト |
| bsdconfig.8 | `usr.sbin/bsdconfig/bsdconfig.8` | マニュアル | bsdconfigコマンドのmanページ |
