# 機能設計書 88-libc（標準Cライブラリ）

## 概要

本ドキュメントは、FreeBSDの標準Cライブラリ（libc）の機能設計を記述する。libcはPOSIX準拠の標準Cライブラリであり、FreeBSD上で動作するすべてのCプログラムの基盤となるランタイムライブラリである。

### 本機能の処理概要

**業務上の目的・背景**：libcはC言語プログラムの基盤的なランタイム環境を提供する。メモリ管理、ファイルI/O、文字列処理、数学関数、プロセス制御、ネットワーク通信等、POSIX標準に準拠した幅広いAPIを提供し、FreeBSD上で動作するほぼすべてのプログラムが暗黙的にリンクする最も重要なライブラリである。

**機能の利用シーン**：FreeBSD上のすべてのCプログラムのランタイム基盤。システムコールラッパー、メモリ確保（malloc/free）、文字列操作（str*/mem*）、ファイルI/O（fopen/fread/fwrite）、プロセス制御（fork/exec/wait）、ネットワーク（socket/connect/bind）、名前解決（gethostbyname/getaddrinfo）、ロケール処理等。

**主要な処理内容**：
1. stdlib: メモリ管理（malloc/free/realloc）、プロセス制御（exit/abort/atexit）、型変換（atoi/strtol）、環境変数（getenv/setenv）、乱数（arc4random）
2. stdio: バッファリングI/O（fopen/fclose/fread/fwrite/fprintf/fscanf）、標準入出力（stdin/stdout/stderr）
3. string: 文字列操作（strcpy/strcat/strcmp/strlen/memcpy/memmove/memset）
4. gen: 汎用関数（alarm/sleep/getcwd/opendir/readdir等）、arc4random暗号学的乱数
5. sys: システムコールラッパー（open/close/read/write/fork/exec/wait/kill等）
6. net/inet: ネットワーク関数（socket/connect/bind/listen/accept）、アドレス変換
7. locale: ロケール処理（setlocale/localeconv）、多バイト文字変換
8. regex: POSIX正規表現（regcomp/regexec/regfree）
9. resolv/nameser: DNS名前解決

**関連システム・外部連携**：カーネルシステムコール（libc経由で呼出）、libpthread（スレッドサポート）、libc++（C++ランタイム）。

**権限による制御**：ライブラリ自体に権限制御はない。各システムコールのカーネル側権限チェックに依存。

## 関連画面

該当なし（ライブラリのため画面は存在しない）

## 機能種別

ランタイムライブラリ / システムコールラッパー

## 入力仕様

### 入力パラメータ

libcは数百のAPIを提供するため、代表的な関数群のシグネチャを示す。

| 関数群 | 代表的API | 説明 |
|--------|---------|------|
| メモリ管理 | malloc(size), free(ptr), realloc(ptr,size) | 動的メモリ確保・解放 |
| 文字列操作 | strcpy(dst,src), strcmp(s1,s2), strlen(s) | 文字列処理 |
| ファイルI/O | fopen(path,mode), fread(buf,size,n,fp) | バッファリングI/O |
| プロセス制御 | fork(), exec*(), wait() | プロセス生成・実行 |
| ネットワーク | socket(domain,type,proto), connect(fd,addr,len) | ソケット通信 |
| 乱数 | arc4random(), arc4random_uniform(upper) | 暗号学的乱数 |

### 入力データソース

アプリケーションからの関数呼出引数、環境変数、ファイルシステム、カーネル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 関数戻り値 | 各種 | 各API仕様に従った戻り値 |
| errno | int | エラー発生時のエラー番号 |
| 出力バッファ | void* | 呼出側が提供するバッファへの書き込み |

### 出力先

呼出側のメモリ空間、ファイルシステム、ネットワーク（各APIに依存）。

## 処理フロー

### 処理シーケンス

```
1. CRT初期化
   └─ csu/: C Runtime Startup。main()呼出前の初期化処理
2. ライブラリ初期化
   └─ _thread_init.c: スレッドスタブ初期化（libpthread未ロード時）
3. アプリケーション実行
   └─ 各APIの呼出に応じた処理
4. システムコール発行
   └─ sys/: ユーザ空間からカーネルへのシステムコール遷移
5. 終了処理
   └─ atexit登録関数の実行、stdio バッファフラッシュ
```

### フローチャート

```mermaid
flowchart TD
    A[プログラム起動] --> B[CRT初期化 csu/]
    B --> C[libc初期化]
    C --> D[main呼出]
    D --> E[アプリケーション実行]
    E --> F{API呼出}
    F -->|ライブラリ関数| G[libc内部処理]
    F -->|システムコール| H[sys/: カーネル遷移]
    G --> E
    H --> I[カーネル処理]
    I --> E
    E --> J[exit/return]
    J --> K[atexit関数実行]
    K --> L[stdioフラッシュ]
    L --> M[_exit: プロセス終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-01 | POSIX準拠 | IEEE Std 1003.1 (POSIX.1)準拠のAPI提供 | 全API |
| BR-88-02 | errno設定 | エラー発生時はerrno変数にエラー番号を設定 | エラー発生時 |
| BR-88-03 | スレッドセーフ | _r付き関数やスレッドローカルerrnoによるスレッドセーフ実装 | マルチスレッド環境 |
| BR-88-04 | シグナルセーフ | async-signal-safe関数のPOSIX規定準拠 | シグナルハンドラ内 |
| BR-88-05 | アーキテクチャ別実装 | amd64/aarch64/arm/i386等のアーキテクチャ固有最適化 | プラットフォーム依存 |

### 計算ロジック

arc4random: ChaCha20ベースの暗号学的擬似乱数生成器。カーネルのエントロピープールから初期化。arc4random_uniform(upper_bound): 均一分布の乱数を剰余バイアスなしで生成。

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOMEM | メモリ不足 | malloc/realloc失敗 | NULL返却、errno設定 |
| ENOENT | ファイル不存在 | fopen等でファイルが見つからない | NULL返却、errno設定 |
| EACCES | 権限エラー | ファイルアクセス権限不足 | -1返却、errno設定 |
| EINVAL | 不正引数 | 無効なパラメータ | -1返却、errno設定 |

### リトライ仕様

EINTR（割込みによるシステムコール中断）に対するリトライは呼出側の責任。一部の関数（SA_RESTART設定時）は自動リトライ。

## トランザクション仕様

該当なし（各API呼出は独立）

## パフォーマンス要件

- string関数（memcpy/memset等）はアーキテクチャ固有のSIMD最適化実装
- stdio関数はユーザ空間バッファリングによりシステムコール回数を削減
- malloc実装（jemalloc）はマルチスレッド環境での効率的なメモリ管理

## セキュリティ考慮事項

- arc4random: 暗号学的に安全な乱数生成（rand/srand非推奨）
- strlcpy/strlcat: バッファオーバーフロー防止関数
- Capsicum対応: cap_rights_get等のCapability関連API
- ASLR対応: PIEバイナリとの連携

## 備考

- libcはFreeBSDの最も巨大なライブラリ。30以上のサブディレクトリで構成
- アーキテクチャ固有コード: aarch64/, amd64/, arm/, i386/, powerpc/, powerpc64/
- システムコールラッパーはsys/ディレクトリに自動生成される
- リンカスクリプト: libc.ldscript, libc_nossp.ldscript

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ディレクトリ構造を理解する

libcは巨大なライブラリのため、まずディレクトリ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Makefile | `lib/libc/Makefile` | libcのビルド構成、サブディレクトリ一覧 |

**読解のコツ**: lib/libc/直下のサブディレクトリがそのまま機能分類に対応。gen/(汎用)、stdio/(標準I/O)、stdlib/(標準ライブラリ)、string/(文字列)、sys/(システムコール)、net/(ネットワーク)、locale/(ロケール)等。アーキテクチャ固有コードはamd64/aarch64/等のディレクトリに配置。

#### Step 2: CRT（C Runtime Startup）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | csu/ | `lib/libc/csu/` | main()呼出前の初期化コード |

#### Step 3: 代表的なサブシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gen/ | `lib/libc/gen/` | 汎用関数群。arc4random、alarm、getcwd、opendir等 |
| 3-2 | stdio/ | `lib/libc/stdio/` | バッファリングI/O。fopen/fclose/fread/fwrite/fprintf |
| 3-3 | stdlib/ | `lib/libc/stdlib/` | malloc/free/realloc、exit/atexit、qsort/bsearch |
| 3-4 | string/ | `lib/libc/string/` | strcpy/strcmp/strlen/memcpy/memset |

**読解のコツ**: 各サブディレクトリにはMakefile.inc（ソースファイル一覧）が配置されている。

#### Step 4: システムコールラッパー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | sys/ | `lib/libc/sys/` | open/close/read/write等のシステムコールラッパー（一部自動生成） |

#### Step 5: プラットフォーム固有コード

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | amd64/ | `lib/libc/amd64/` | x86_64固有の最適化実装（string関数のSIMD版等） |
| 5-2 | aarch64/ | `lib/libc/aarch64/` | ARM64固有実装 |

### プログラム呼び出し階層図

```
アプリケーション
    |
    +-- stdio関数 (fopen/fread/fwrite/fprintf)
    |       +-- バッファ管理
    |       +-- sys/: read/write システムコール
    |
    +-- stdlib関数 (malloc/free/exit)
    |       +-- jemalloc実装
    |       +-- sys/: mmap/munmap
    |
    +-- string関数 (strcpy/memcpy)
    |       +-- アーキテクチャ最適化版
    |
    +-- gen関数 (arc4random/getcwd)
    |       +-- sys/: sysctl/getentropy
    |
    +-- net関数 (socket/connect)
    |       +-- sys/: socket/connect システムコール
    |
    +-- resolv関数 (getaddrinfo)
            +-- DNS問い合わせ
            +-- /etc/hosts参照
```

### データフロー図

```
[入力]                        [処理]                           [出力]

アプリケーション呼出 ──> libc API ──> カーネルシステムコール
                         ユーザ空間処理
                         バッファリング
                         型変換/文字列処理

カーネル応答 ──> libc ──> アプリケーション
                 errno設定
                 バッファ管理
                 データ変換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Makefile | `lib/libc/Makefile` | ビルド設定 | libcトップレベルビルド |
| gen/ | `lib/libc/gen/` | ソースディレクトリ | 汎用関数群 |
| stdio/ | `lib/libc/stdio/` | ソースディレクトリ | 標準I/O |
| stdlib/ | `lib/libc/stdlib/` | ソースディレクトリ | 標準ライブラリ |
| string/ | `lib/libc/string/` | ソースディレクトリ | 文字列操作 |
| sys/ | `lib/libc/sys/` | ソースディレクトリ | システムコールラッパー |
| net/ | `lib/libc/net/` | ソースディレクトリ | ネットワーク関数 |
| inet/ | `lib/libc/inet/` | ソースディレクトリ | インターネットアドレス |
| locale/ | `lib/libc/locale/` | ソースディレクトリ | ロケール処理 |
| regex/ | `lib/libc/regex/` | ソースディレクトリ | POSIX正規表現 |
| resolv/ | `lib/libc/resolv/` | ソースディレクトリ | DNS名前解決 |
| nameser/ | `lib/libc/nameser/` | ソースディレクトリ | ネームサーバ |
| iconv/ | `lib/libc/iconv/` | ソースディレクトリ | 文字コード変換 |
| db/ | `lib/libc/db/` | ソースディレクトリ | Berkeley DB |
| csu/ | `lib/libc/csu/` | ソースディレクトリ | C Runtime Startup |
| amd64/ | `lib/libc/amd64/` | ソースディレクトリ | x86_64固有実装 |
| aarch64/ | `lib/libc/aarch64/` | ソースディレクトリ | ARM64固有実装 |
| libc.ldscript | `lib/libc/libc.ldscript` | リンカスクリプト | libcリンカスクリプト |
