# 機能設計書 99-SNMPエージェント

## 概要

本ドキュメントは、FreeBSDのSNMPエージェント（bsnmpd）の機能設計を記述する。bsnmpdはBEGEMOT SNMPデーモンであり、SNMP（Simple Network Management Protocol）を使用してシステムの監視・管理を可能にするエージェントプログラムである。

### 本機能の処理概要

bsnmpdは、軽量かつモジュラーなSNMPエージェント実装である。SNMPv1/v2c/v3プロトコルに対応し、MIB（Management Information Base）ツリーの参照・設定要求を処理する。動的にロード可能なモジュール機構により、MIBの拡張が容易な設計となっている。

**業務上の目的・背景**：ネットワーク管理者がFreeBSDシステムの状態（CPU使用率、メモリ使用量、ネットワークインタフェース統計等）をリモートから監視する必要がある。bsnmpdはSNMPプロトコルを通じてこれらの情報を提供し、ネットワーク管理システム（NMS）との統合を可能にする。

**機能の利用シーン**：ネットワーク監視システム（Nagios、Zabbix等）からのシステム監視、インタフェーストラフィック統計の収集、システム情報のリモート取得、SNMPトラップによる異常通知などで使用される。

**主要な処理内容**：
1. SNMP GET/GETNEXT/GETBULK要求の処理：MIBオブジェクトの値取得
2. SNMP SET要求の処理：MIBオブジェクトの値設定
3. SNMPトラップ/通知の送信：異常状態の通知
4. SNMPv3セキュリティ：USM（User-based Security Model）による認証・暗号化
5. VACM（View-based Access Control Model）によるアクセス制御
6. モジュール管理：MIB拡張モジュールの動的ロード
7. コミュニティ文字列ベースのアクセス制御（v1/v2c）

**関連システム・外部連携**：ネットワーク管理システム（NMS）、SNMPマネージャ、カーネルのMIB情報（sysctl等）

**権限による制御**：bsnmpdはroot権限で起動する必要がある（特権ポート161へのバインド、システム情報へのアクセスのため）。SNMPv3のUSMによるユーザ認証とVACMによるMIBビューのアクセス制御が提供される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連画面なし |

## 機能種別

システムサービス（ネットワーク管理エージェント）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| snmpd.config | ファイル | Yes | bsnmpd設定ファイル | 構文チェック |
| -c config | string | No | 設定ファイルパス | 有効なファイルパス |
| -d | フラグ | No | デバッグモード | - |
| -p pidfile | string | No | PIDファイルパス | 有効なファイルパス |

### 入力データソース

- snmpd.config設定ファイル
- SNMPマネージャからのSNMPリクエスト（UDP ポート161）
- カーネルMIB情報（sysctl経由）
- ネットワークインタフェース統計

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SNMPレスポンス | SNMPパケット | GET/SET要求への応答 |
| SNMPトラップ | SNMPパケット | 異常通知（ポート162へ送信） |
| ログ | syslog | 動作ログ |

### 出力先

- SNMPマネージャへのUDP応答
- トラップホストへのSNMPトラップ（UDP ポート162）
- syslog

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ 設定ファイル解析、MIBツリー構築、ソケットオープン、モジュールロード
2. メインループ
   └─ UDP ポート161でSNMPリクエスト待ち受け
3. リクエスト受信・認証
   └─ コミュニティ文字列（v1/v2c）またはUSM（v3）で認証
4. PDU処理
   └─ GET/GETNEXT/GETBULK/SET操作の実行
5. MIBツリー検索
   └─ OIDに対応するMIBモジュールのハンドラ呼び出し
6. レスポンス生成・送信
   └─ SNMPレスポンスパケットの構築・送信
```

### フローチャート

```mermaid
flowchart TD
    A[初期化: 設定読み込み・モジュールロード] --> B[UDP 161 リスン]
    B --> C[SNMPリクエスト受信]
    C --> D{プロトコルバージョン}
    D -->|v1/v2c| E[コミュニティ文字列認証]
    D -->|v3| F[USM認証・暗号化復号]
    E --> G{VACM アクセスチェック}
    F --> G
    G -->|許可| H{PDU種別}
    G -->|拒否| I[エラーレスポンス]
    H -->|GET| J[MIBツリー検索・値取得]
    H -->|SET| K[MIBツリー検索・値設定]
    H -->|GETNEXT/GETBULK| L[MIBツリー次エントリ取得]
    J --> M[レスポンス送信]
    K --> M
    L --> M
    I --> M
    M --> B
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-1 | デフォルトコミュニティ | readコミュニティは"public"、writeは"geheim" | 設定未変更時 |
| BR-99-2 | トラップポート | SNMPトラップはデフォルトでポート162に送信 | トラップ送信時 |
| BR-99-3 | セキュリティモデル | v1=1, v2c=2, USM=3 | プロトコルバージョンに依存 |
| BR-99-4 | セキュリティレベル | noAuthNoPriv=1, authNoPriv=2, authPriv=3 | USM使用時 |
| BR-99-5 | 認証プロトコル | HMAC-MD5、HMAC-SHA対応 | USM認証時 |
| BR-99-6 | 暗号プロトコル | DES、AES-128対応 | USMプライバシー時 |

### 計算ロジック

OIDツリーの辞書順検索（lexicographic order）によるGETNEXT処理。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを使用しない。MIB値はカーネルやシステム情報から動的に取得する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| noSuchName | OIDエラー | 要求されたOIDが存在しない | エラーレスポンス返却 |
| authorizationError | 認証エラー | コミュニティ/USM認証失敗 | エラーレスポンス返却 |
| genErr | 一般エラー | MIBモジュール内部エラー | エラーレスポンス返却 |
| tooBig | サイズエラー | レスポンスがパケットサイズを超過 | パケット分割またはエラー返却 |

### リトライ仕様

SNMPはUDPベースのため、リトライはマネージャ側の責務。

## トランザクション仕様

SNMP SET操作は、test-commit-rollbackの3フェーズで実行される（SNMP RFC準拠）。

## パフォーマンス要件

- SNMPポーリングに対する低レイテンシ応答
- GETBULK操作での大量OID効率的処理

## セキュリティ考慮事項

- SNMPv1/v2c: コミュニティ文字列は平文送信（セキュアでない環境での使用は非推奨）
- SNMPv3 USM: HMAC-MD5/SHA認証、DES/AES暗号化によるセキュア通信
- VACM: MIBビューによる細粒度アクセス制御
- デフォルトコミュニティ文字列("public")の変更を強く推奨

## 備考

- bsnmpdはBEGEMOT SNMPプロジェクト由来
- contrib/bsnmp/以下にアップストリームソースが配置
- モジュール: snmp_mibII（標準MIB-II）、snmp_ntp（NTP MIB）、snmp_target、snmp_usm、snmp_vacm等

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | snmp.h | `contrib/bsnmp/lib/snmp.h` | SNMPプロトコルの基本構造体。パケット構造、PDU構造、バインディングリスト等 |
| 1-2 | asn1.h | `contrib/bsnmp/lib/asn1.h` | ASN.1/BERエンコーディングの構造体 |
| 1-3 | snmpmod.h | `contrib/bsnmp/snmpd/snmpmod.h` | MIBモジュールインタフェース定義 |
| 1-4 | snmpd.h | `contrib/bsnmp/snmpd/snmpd.h` | bsnmpd内部構造体定義 |

**読解のコツ**: bsnmpdはモジュラーアーキテクチャ。snmpmod.hがモジュール開発者向けのインタフェースを定義。各MIBモジュールはstruct snmp_moduleを実装してdlopen/dlsymで動的ロードされる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.c | `contrib/bsnmp/snmpd/main.c` | メインプログラム。初期化、設定読み込み、メインイベントループ |

#### Step 3: 設定処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config.c | `contrib/bsnmp/snmpd/config.c` | snmpd.config設定ファイルの解析 |
| 3-2 | snmpd.config | `usr.sbin/bsnmpd/bsnmpd/snmpd.config` | 設定ファイルサンプル。コミュニティ、認証、モジュール等の設定 |

**主要処理フロー**:
- 変数宣言（location, contact, system等）
- コミュニティ文字列設定（read="public", write="geheim"）
- セキュリティモデル定数定義（securityModelSNMPv1=1等）
- 認証/暗号プロトコルOID定義

#### Step 4: プロトコル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | snmp.c | `contrib/bsnmp/lib/snmp.c` | SNMPパケットのエンコード/デコード |
| 4-2 | snmpcrypto.c | `contrib/bsnmp/lib/snmpcrypto.c` | USM認証・暗号処理 |
| 4-3 | asn1.c | `contrib/bsnmp/lib/asn1.c` | ASN.1/BERエンコーディング |

#### Step 5: トランスポート層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | trans_inet.c | `contrib/bsnmp/snmpd/trans_inet.c` | INETソケットトランスポート（UDP/TCP） |
| 5-2 | trans_lsock.c | `contrib/bsnmp/snmpd/trans_lsock.c` | ローカルソケットトランスポート |

#### Step 6: MIBモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | snmp_mibII | `contrib/bsnmp/snmp_mibII/` | 標準MIB-IIモジュール（システム情報、インタフェース統計等） |

### プログラム呼び出し階層図

```
bsnmpd main() [main.c]
    │
    ├─ config.c: 設定ファイル解析
    │      └─ snmpd.config読み込み
    │
    ├─ モジュールロード (dlopen)
    │      ├─ snmp_mibII (MIB-II)
    │      ├─ snmp_usm (USM)
    │      ├─ snmp_vacm (VACM)
    │      └─ その他モジュール
    │
    ├─ トランスポート初期化
    │      ├─ trans_inet.c: UDP/TCP ポート161
    │      └─ trans_lsock.c: ローカルソケット
    │
    └─ イベントループ
           │
           ├─ SNMPリクエスト受信
           │      └─ snmp.c: パケットデコード
           │
           ├─ 認証処理
           │      ├─ コミュニティ文字列チェック (v1/v2c)
           │      └─ snmpcrypto.c: USM処理 (v3)
           │
           ├─ アクセス制御
           │      └─ snmp_vacm: VACMチェック
           │
           ├─ PDU処理
           │      └─ MIBモジュールハンドラ呼び出し
           │
           ├─ レスポンス送信
           │      └─ snmp.c: パケットエンコード
           │
           └─ トラップ送信
                  └─ trap.c: トラップ生成・送信
```

### データフロー図

```
[入力]                          [処理]                        [出力]

SNMPマネージャ          ───▶ UDP 161受信             ───▶ パケットデコード
(GET/SET要求)                  │
                        asn1.c/snmp.c: デコード
                               │
                        認証・アクセス制御
                               │
                        MIBモジュール呼び出し
                               │
snmpd.config           ───▶ config.c: 設定解析
                               │
カーネル情報            ───▶ MIBモジュール           ───▶ SNMPレスポンス
(sysctl, ifstat等)             │
                               └─ trap.c             ───▶ SNMPトラップ (162)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.c | `contrib/bsnmp/snmpd/main.c` | ソース | メインプログラム |
| config.c | `contrib/bsnmp/snmpd/config.c` | ソース | 設定ファイル解析 |
| snmpd.h | `contrib/bsnmp/snmpd/snmpd.h` | ヘッダ | 内部構造体定義 |
| snmpmod.h | `contrib/bsnmp/snmpd/snmpmod.h` | ヘッダ | モジュールインタフェース |
| trap.c | `contrib/bsnmp/snmpd/trap.c` | ソース | トラップ処理 |
| action.c | `contrib/bsnmp/snmpd/action.c` | ソース | SET操作処理 |
| export.c | `contrib/bsnmp/snmpd/export.c` | ソース | MIBエクスポート |
| trans_inet.c | `contrib/bsnmp/snmpd/trans_inet.c` | ソース | INETトランスポート |
| trans_lsock.c | `contrib/bsnmp/snmpd/trans_lsock.c` | ソース | ローカルソケットトランスポート |
| snmp.c | `contrib/bsnmp/lib/snmp.c` | ソース | SNMPパケット処理 |
| snmpcrypto.c | `contrib/bsnmp/lib/snmpcrypto.c` | ソース | USM認証・暗号 |
| asn1.c | `contrib/bsnmp/lib/asn1.c` | ソース | ASN.1エンコーディング |
| snmpd.config | `usr.sbin/bsnmpd/bsnmpd/snmpd.config` | 設定 | 設定ファイルサンプル |
