---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-プロセス管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **ULEスケジューラのO(1)計算量**: 実装の詳細レベルでの確認が必要
  2. **コンテキスト切替のマイクロ秒オーダー**: 性能測定データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sys/kern/kern_fork.c` - fork/vfork/rfork実装（1279行）
- E-02: `sys/kern/kern_exec.c` - execve実装（2119行）
- E-03: `sys/kern/kern_exit.c` - exit/wait実装（1629行）
- E-04: `sys/kern/kern_proc.c` - プロセス情報管理（3633行）
- E-05: `sys/kern/kern_context.c` - コンテキスト切替（127行）
- E-06: `sys/kern/sched_ule.c` - ULEスケジューラ（3604行）
- E-07: `sys/kern/kern_switch.c` - 切替共通処理（671行）
- E-08: `sys/sys/proc.h` - proc/thread構造体定義
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sys_fork()は100行目に定義されている | E-01 | ○ |
| C-02 | sys_vfork()は145行目に定義されている | E-01 | ○ |
| C-03 | sys_rfork()は162行目に定義されている | E-01 | ○ |
| C-04 | fork1()は894行目に定義されfork処理の中核 | E-01 | ○ |
| C-05 | do_fork()は409行目に定義され子プロセスを初期化 | E-01 | ○ |
| C-06 | sys_execve()は225行目に定義されている | E-02 | ○ |
| C-07 | kern_execve()は351行目に定義されている | E-02 | ○ |
| C-08 | do_execve()は393行目に定義されている | E-02 | ○ |
| C-09 | exit1()は225行目に定義されている | E-03 | ○ |
| C-10 | kern_wait6()は1393行目に定義されている | E-03 | ○ |
| C-11 | initプロセス終了時にpanic発生（244行目） | E-03 | ○ |
| C-12 | struct procは653行目に定義されている | E-08 | ○ |
| C-13 | p_stateはPRS_NEW/PRS_NORMAL/PRS_ZOMBIEの3状態 | E-08 | ○ |
| C-14 | sys_getcontext()は60行目に定義されている | E-05 | ○ |
| C-15 | sys_setcontext()は79行目に定義されている | E-05 | ○ |
| C-16 | sys_swapcontext()は100行目に定義されている | E-05 | ○ |
| C-17 | ULEスケジューラは独立CPUランキューを持つ | E-06 | ○ |
| C-18 | fork1()でRFフラグのバリデーション実施 | E-01 | ○ |
| C-19 | fork時にCOW（Copy-on-Write）が使用される | E-01 | ○ |
| C-20 | 非特権ユーザはmaxproc-10が上限 | E-01 | ○ |
| C-21 | DTraceフック（dtrace_fasttrap_fork等）が存在 | E-01 | ○ |
| C-22 | MAC フレームワークとの連携がある | E-01, E-02 | ○ |
| C-23 | exit1()でthread_single(SINGLE_EXIT)により他スレッドを停止 | E-03 | ○ |
| C-24 | ULEスケジューラはO(1)の計算量 | **根拠なし** | △ |
| C-25 | コンテキスト切替はマイクロ秒オーダー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ULEスケジューラの計算量に関する公式ドキュメントまたはベンチマークデータが不足
  - 候補：FreeBSD開発者メーリングリスト / ULEスケジューラの論文 / カーネルベンチマーク結果
- コンテキスト切替の性能に関する測定データが不足
  - 候補：FreeBSDベンチマーク結果 / lmbenchテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造定義と行番号の対応（ソースコードで直接確認済み）
- 0: 低リスク - システムコールインタフェースの仕様（ソースコードから読み取り）
- 1: 中リスク - パフォーマンス要件の数値（実測データなし）

## 6) レビュアーチェックリスト（最小）
- [ ] struct procの主要フィールド説明が最新のソースコードと一致しているか
- [ ] fork1()のエラーハンドリングパスが網羅されているか
- [ ] execve処理でのセキュリティ考慮事項（setuid処理等）が正確か
- [ ] ULEスケジューラの優先度計算ロジックの記述が正確か
- [ ] exit処理におけるリソース解放順序が正しく記述されているか
