---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-イベント通知（kqueue）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **全フィルタ種別の網羅的確認**: EVFILT_*の完全なリストの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/kern_event.c` - kqueue/kevent実装（3377行）
- E-02: `sys/sys/event.h` - struct kevent/EVFILT_*/EV_*定義
- E-03: `sys/sys/eventvar.h` - 内部データ構造定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kern_event.cは3377行 | E-01 | ○ |
| C-02 | sys_kqueue()は1194行目に定義 | E-01 | ○ |
| C-03 | sys_kqueuex()は1201行目に定義 | E-01 | ○ |
| C-04 | sys_kevent()は1291行目に定義 | E-01 | ○ |
| C-05 | kqueue_register()は1652行目に定義 | E-01 | ○ |
| C-06 | kqueue_scan()は2083行目に定義 | E-01 | ○ |
| C-07 | kqueuexでKQUEUE_CLOEXEC/CPONFORKフラグサポート | E-01 | ○ |
| C-08 | 1201-1206行目でフラグバリデーション | E-01 | ○ |
| C-09 | COMPAT_FREEBSD11のkeventサポート | E-01 | ○ |
| C-10 | kqueue_register()の引数（kqueue, kevent, thread, mflag） | E-01 | ○ |
| C-11 | kqueue_scan()の引数（kqueue, maxevents, copyops, timespec, keva, thread） | E-01 | ○ |
| C-12 | filteropsによるフィルタ固有処理の抽象化 | E-01 | ○ |
| C-13 | knote構造体による個々の監視エントリ管理 | E-01 | ○ |
| C-14 | マーカーknoteを使用した安全なリスト走査 | E-01 | ○ |
| C-15 | kevent_copyopsによるcopyout抽象化 | E-01 | ○ |
| C-16 | O(1)イベント通知 | E-01 | ○ |
| C-17 | Capsicumケイパビリティモードとの互換性 | E-01 | ○ |
| C-18 | 全EVFILT_*フィルタ種別の完全なリスト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- event.hで定義されている全EVFILT_*定数の完全なリスト
  - 候補：sys/sys/event.hのEVFILT_*定義の全列挙

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 関数の行番号対応（ソースコードで確認済み）
- 0: 低リスク - kqueue/keventの基本構造
- 1: 中リスク - フィルタ種別の網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] sys_kqueue/keventの行番号が最新ソースと一致するか
- [ ] kqueue_register()のフィルタ選択ロジックが正確か
- [ ] kqueue_scan()のリスト走査アルゴリズムが正確か
- [ ] 全EVFILT_*フィルタの列挙が完全か
- [ ] EV_ONESHOT/EV_CLEAR/EV_DISPATCHのセマンティクスが正確か
