---
generated_at: 2026-02-01 11:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 16
  claims_without_evidence: 4
confidence_derived: 0.80
---

# 根拠レポート：100-sendmail（メール配送）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：16 / 20、根拠なし：4
- 優先レビュー（高）
  1. **デフォルトキュー再送間隔（30分）の正確性**：sendmail.cfの確認が必要
  2. **バウンス期限（5日）の正確性**：sendmail.cfの確認が必要
  3. **SMTP AUTH対応メカニズム一覧の正確性**：設定確認が必要
  4. **milterインタフェースの詳細**：libmilterの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `contrib/sendmail/src/main.c` - メインプログラム（存在確認、4904行）
- E-02: `contrib/sendmail/src/` - ソースファイル一覧
- E-03: `contrib/sendmail/mail.local/` - ローカル配送プログラム
- E-04: `contrib/sendmail/include/` - ヘッダファイル
- E-05: `libexec/mail.local/` - FreeBSDビルドディレクトリ
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | contrib/sendmail/以下にソース配置 | E-01 (ファイルパス) | ○ |
| C-02 | main.cは4904行 | E-01 (wc -l確認) | ○ |
| C-03 | alias.c, collect.c, conf.c, conf.h, control.c等の存在 | E-02 (ディレクトリ一覧) | ○ |
| C-04 | daemon.c, deliver.c, domain.c, envelope.c, headers.cの存在 | E-02 | ○ |
| C-05 | err.c, macro.c等の存在 | E-02 | ○ |
| C-06 | mail.local/の存在 | E-03, E-05 | ○ |
| C-07 | libmilterディレクトリの存在 | contrib/sendmail/libmilter/ (ディレクトリ存在) | ○ |
| C-08 | libsm, libsmdb, libsmutilの存在 | contrib/sendmail/ (ディレクトリ存在) | ○ |
| C-09 | makemapディレクトリの存在 | contrib/sendmail/makemap/ (ディレクトリ存在) | ○ |
| C-10 | mailstatsディレクトリの存在 | contrib/sendmail/mailstats/ (ディレクトリ存在) | ○ |
| C-11 | cfディレクトリの存在 | contrib/sendmail/cf/ (ディレクトリ存在) | ○ |
| C-12 | SMTPデフォルトポート25 | SMTP標準 (RFC 5321) | ○ |
| C-13 | サブミッションポート587 | SMTP標準 (RFC 6409) | ○ |
| C-14 | メールキューパス /var/spool/mqueue/ | FreeBSD標準パス | ○ |
| C-15 | メールボックスパス /var/mail/ | FreeBSD標準パス | ○ |
| C-16 | aliasesデータベースによるアドレス変換 | alias.cファイルの存在 | ○ |
| C-17 | デフォルトキュー再送間隔が30分 | **根拠なし** | △ |
| C-18 | バウンス期限がデフォルト5日 | **根拠なし** | △ |
| C-19 | SMTP AUTH対応メカニズム（CRAM-MD5等） | **根拠なし** | △ |
| C-20 | STARTTLS暗号化サポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17, C-18: デフォルト値はsendmail.cfまたはconf.cの定数確認が必要
  - 候補: contrib/sendmail/cf/cf/freebsd*.mc / contrib/sendmail/src/conf.c
- C-19: SMTP AUTH対応メカニズムはSASL設定に依存する可能性
  - 候補: contrib/sendmail/src/内のAUTH関連コード
- C-20: STARTTLSサポートはコンパイル時オプション確認が必要
  - 候補: contrib/sendmail/src/conf.h内のSTARTTLS関連定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構造・ディレクトリ構成
- 1: 中リスク - デフォルト設定値
- 2: 高リスク - セキュリティ機能の詳細（SMTP AUTH, STARTTLS）
- 1: 中リスク - milterインタフェースの詳細

## 6) レビュアーチェックリスト（最小）
- [ ] sendmail.cfのデフォルトキュー再送間隔を確認
- [ ] バウンス期限のデフォルト値を確認
- [ ] SMTP AUTH対応認証メカニズムを確認
- [ ] STARTTLS設定の確認
- [ ] milterインタフェースの詳細を確認
- [ ] FreeBSDでのsendmail有効化/無効化設定を確認
