---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：101-inetd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **IPsecポリシー設定の詳細**: inetd.cにIPSEC条件付きコンパイルは確認できるが動作詳細は未検証
  2. **RPC機能の詳細フロー**: RPCサービス登録・解除の完全な処理フローは未検証

## 2) 参照した情報（Evidence一覧）
- E-01: `usr.sbin/inetd/inetd.c` (メインソースコード)
- E-02: `usr.sbin/inetd/inetd.h` (ヘッダファイル、データ構造定義)
- E-03: `usr.sbin/inetd/builtins.c` (内蔵サービス実装)
- E-04: `usr.sbin/inetd/pathnames.h` (パス定数定義)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | inetdは/etc/inetd.confを設定ファイルとして使用する | E-04 (34行目: _PATH_INETDCONF) | ○ |
| C-02 | servtab構造体がサービス定義の中核データ構造である | E-02 (72-125行目) | ○ |
| C-03 | select(2)で複数ソケットを同時監視する | E-01 (249行目: fd_set allsock) | ○ |
| C-04 | TOOMANY=256がデフォルトのレート制限値 | E-01 (188行目: #define TOOMANY 256) | ○ |
| C-05 | CNT_INTVL=60秒がレート制限間隔 | E-01 (190行目: #define CNT_INTVL 60) | ○ |
| C-06 | RETRYTIME=600秒(10分)がリトライ待ち時間 | E-01 (191行目: #define RETRYTIME (60*10)) | ○ |
| C-07 | echo, discard, time, daytime, chargen, tcpmux, authが内蔵サービス | E-03 (74-99行目: biltins配列) | ○ |
| C-08 | コマンドラインオプション -d, -l, -w, -W, -R, -a, -c, -C, -p, -s | E-01 (343行目: getoptの引数文字列 "dlwWR:a:c:C:p:s:") | ○ |
| C-09 | procinfo構造体で子プロセスを追跡 | E-02 (52-56行目) | ○ |
| C-10 | conninfo構造体でIP別接続を追跡 | E-02 (58-63行目) | ○ |
| C-11 | PERIPSIZE=256のハッシュテーブルでIP別管理 | E-02 (65行目) | ○ |
| C-12 | PIDファイルは/var/run/inetd.pid | E-04 (35行目: _PATH_INETDPID) | ○ |
| C-13 | TCP Wrapper(libwrap)によるアクセス制御 | E-01 (128-130行目: #ifdef LIBWRAP, 156-160行目: ISWRAP) | ○ |
| C-14 | LOGIN_CAPによるリソース制限 | E-01 (162-167行目: #ifdef LOGIN_CAP) | ○ |
| C-15 | MAXARGVは20 | E-02 (88行目: #define MAXARGV 20) | ○ |
| C-16 | サービスタイプはNORM/MUX/MUXPLUS/FAITH | E-02 (44-47行目) | ○ |
| C-17 | IPsecポリシーの適用が可能 | E-01 (136-141行目: #ifdef IPSEC) | △ |
| C-18 | RPCサービスの登録・管理が可能 | E-01 (110-111行目: rpc/rpc.h, rpc/pmap_clnt.h) | △ |

## 4) 不足情報（Unknown / Missing）
- IPsecポリシー設定の具体的な動作フローは条件付きコンパイルされており、ビルド設定に依存するため完全な検証が困難
  - 候補：ipsecsetup関数の実装詳細 / netipsec/ipsec.hの参照
- RPCサービスの完全な登録・解除フローは、rpc関連関数の呼び出し詳細を追跡する必要がある
  - 候補：unregisterrpc関数 / pmap_unset呼び出し / netconfig関連処理

## 5) リスクフラグ（レビュー観点）
- 0: servtab構造体の定義と使用は明確に確認済み
- 0: 内蔵サービスの一覧と実装は完全に確認済み
- 1: IPsec・RPC関連の処理詳細は条件付きコンパイルのため中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] inetd.confの設定フォーマット仕様が正確か確認
- [ ] select()メインループの処理順序が実装と一致するか確認
- [ ] IPsec/RPC関連の記述がビルド設定と整合するか確認
- [ ] TCP Wrapperの判定条件（ISWRAPマクロ）が正確に記述されているか確認
