---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 11
  claims_without_evidence: 4
confidence_derived: 0.73
---

# 根拠レポート：104-Bluetooth

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.73**
  - 根拠あり：11 / 15、根拠なし：4
- 優先レビュー（高）
  1. **各デーモンの内部実装詳細**: 個別ツールのソースコードは未読み込み
  2. **hcsecdのペアリングフロー**: 設定ファイルの仕様は未確認
  3. **btpandのPAN実装詳細**: ソースコード未読み込み

## 2) 参照した情報（Evidence一覧）
- E-01: `lib/libbluetooth/bluetooth.h` (ライブラリヘッダ)
- E-02: `usr.bin/bluetooth/` (ディレクトリ一覧)
- E-03: `usr.sbin/bluetooth/` (ディレクトリ一覧)
- E-04: `lib/libbluetooth/` (ディレクトリ一覧)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BlueZ互換マクロ(bacmp, bacpy等)が提供されている | E-01 (62-69行目) | ○ |
| C-02 | bt_gethostbyname等のホスト解決APIが存在 | E-01 (75-79行目) | ○ |
| C-03 | netgraphヘッダ(ng_bluetooth, ng_hci, ng_l2cap, ng_btsocket)をインクルード | E-01 (49-53行目) | ○ |
| C-04 | usr.bin/bluetoothにbthost, btsockstat, rfcomm_sppdが存在 | E-02 (ディレクトリ一覧) | ○ |
| C-05 | usr.sbin/bluetoothにhccontrol, hcsecd, l2control等が存在 | E-03 (ディレクトリ一覧) | ○ |
| C-06 | ath3kfw, bcmfw, iwmbtfw, rtlbtfwのFWローダが存在 | E-03 (ディレクトリ一覧) | ○ |
| C-07 | libbluetooth内にbluetooth.c, hci.c, dev.c, hosts, protocolsが存在 | E-04 (ディレクトリ一覧) | ○ |
| C-08 | sdpd SDPサーバデーモンが存在 | E-03 (ディレクトリ一覧) | ○ |
| C-09 | bthidd Bluetooth HIDデーモンが存在 | E-03 (ディレクトリ一覧) | ○ |
| C-10 | btpand Bluetooth PANデーモンが存在 | E-03 (ディレクトリ一覧) | ○ |
| C-11 | bluetooth-config設定ツールが存在 | E-03 (ディレクトリ一覧) | ○ |
| C-12 | hcsecdのPINコード/リンクキー管理の詳細フロー | **根拠なし** | △ |
| C-13 | bthiddのHIDプロファイル実装の詳細 | **根拠なし** | △ |
| C-14 | btpandのPAN実装の詳細 | **根拠なし** | △ |
| C-15 | Simple Secure Pairing (SSP)サポートの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各デーモン(hcsecd, bthidd, btpand, sdpd)の個別ソースコードは未読み込みのため、内部実装の詳細が未検証
  - 候補：各デーモンのmain.c / 設定ファイルの仕様 / manページの参照
- SSP(Simple Secure Pairing)サポートの有無はng_hciカーネルモジュールの実装に依存し、未検証
  - 候補：sys/netgraph/bluetooth/include/ng_hci.hの確認

## 5) リスクフラグ（レビュー観点）
- 0: ディレクトリ構造とファイル存在は確認済み
- 0: libbluetooth APIの基本定義は確認済み
- 2: 個別デーモンの内部実装詳細は高リスク（ソースコード未読み込み）
- 1: セキュリティ関連（ペアリング、SSP）の実装詳細は中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 各デーモンの実際の機能と設計書の記述が一致するか確認
- [ ] hcsecdのペアリング処理フローが正確か確認
- [ ] Bluetooth 4.0/5.0のLow Energy (BLE)サポートの有無を確認
- [ ] ファームウェアローダの対応チップセット一覧が正確か確認
