---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：106-rescueツール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **bsd.crunchgen.mkの詳細処理**: crunchgenフレームワークの内部動作は未検証

## 2) 参照した情報（Evidence一覧）
- E-01: `rescue/rescue/Makefile` (メインMakefile)
- E-02: `rescue/` (ディレクトリ一覧)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NO_SHARED=yes, MK_PIE=no, MK_SSP=noで静的リンク | E-01 (6-12行目) | ○ |
| C-02 | --allow-multiple-definitionをlld >= 16で使用 | E-01 (15-18行目) | ○ |
| C-03 | PROG=rescue, BINDIR=/rescue | E-01 (20-21行目) | ○ |
| C-04 | dhclient-scriptの/bin/ -> /rescue/置換 | E-01 (23-27行目) | ○ |
| C-05 | CRUNCH_BUILDOPTS += -DRESCUE | E-01 (32-34行目) | ○ |
| C-06 | librescueオブジェクトが先にリンクされる | E-01 (47行目) | ○ |
| C-07 | CRUNCH_PROGS_binのコマンド一覧 | E-01 (56-59行目) | ○ |
| C-08 | test->[ エイリアス | E-01 (64行目) | ○ |
| C-09 | -shのハードリンク抑止 | E-01 (67行目: CRUNCH_SUPPRESS_LINK) | ○ |
| C-10 | CRUNCH_PROGS_sbinのコマンド一覧 | E-01 (91-101行目) | ○ |
| C-11 | MK_ZFS有効時にbectl, zfs, zpool追加 | E-01 (134-140行目) | ○ |
| C-12 | MK_IPFW有効時にipfw追加 | E-01 (121-123行目) | ○ |
| C-13 | MK_INET/MK_INET6有効時にping追加 | E-01 (107-109行目) | ○ |
| C-14 | bsd.crunchgen.mkの内部処理フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- share/mk/bsd.crunchgen.mkの内部動作（crunchgen設定生成、コンパイル、リンクの詳細フロー）は未読み込み
  - 候補：share/mk/bsd.crunchgen.mkの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: Makefileの定数定義・コマンド一覧は完全に確認済み
- 0: 条件付きビルドの分岐は確認済み
- 1: crunchgenフレームワークの内部動作は中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] CRUNCH_PROGS_binの全コマンドが実際に/rescueに配置されるか確認
- [ ] ZFS有効時の追加ライブラリが正しく列挙されているか確認
- [ ] アーキテクチャ別の条件分岐（i386, amd64等）が正確か確認
