---
generated_at: 2026-02-01 11:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：109-manページ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **bsd.man.mkの詳細ルール**: マニュアルインストールの具体的なルールは未検証
  2. **makewhatis/mandocの内部動作**: 関連ツールの詳細は未読み込み

## 2) 参照した情報（Evidence一覧）
- E-01: `share/man/` (ディレクトリ一覧)
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面機能マッピング)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | man1, man3, man3lua, man4, man5, man6, man7, man8, man9セクションが存在 | E-01 (ディレクトリ一覧) | ○ |
| C-02 | Makefileが存在 | E-01 (ディレクトリ一覧) | ○ |
| C-03 | man3luaセクションが存在 | E-01 (ディレクトリ一覧: man3lua) | ○ |
| C-04 | 画面31「ドキュメントインストール画面」との関連 | E-02 (64行目) | ○ |
| C-05 | man1はユーザコマンド、man3はライブラリ等のセクション分類 | E-03 + UNIXの標準規約 | ○ |
| C-06 | mdoc(7)形式でマニュアルが記述される | E-03 (FreeBSD標準) | ○ |
| C-07 | share/man/ディレクトリに共通マニュアルが集約される | E-01 | ○ |
| C-08 | 各コンポーネントのMakefileにもMANが定義される | E-03 (FreeBSDビルドシステムの慣例) | ○ |
| C-09 | mandocによるフォーマット処理 | E-03 (FreeBSD標準ツール) | ○ |
| C-10 | apropos/man -kによるキーワード検索 | E-03 (FreeBSD標準ツール) | ○ |
| C-11 | bsd.man.mkの詳細インストールルール | **根拠なし** | △ |
| C-12 | makewhatis/mandocの内部動作詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- share/mk/bsd.man.mkの内容は未読み込みのため、マニュアルインストールの具体的なルール（圧縮、リンク作成等）が未検証
  - 候補：share/mk/bsd.man.mkの読み込み
- mandoc(1)、makewhatis(8)の内部動作は対象ソースが異なるため未検証
  - 候補：usr.bin/mandocの読み込み

## 5) リスクフラグ（レビュー観点）
- 0: セクション構造とディレクトリ配置は確認済み
- 0: 画面機能マッピングとの関連は確認済み
- 1: bsd.man.mkの詳細は中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 各セクション（man1〜man9）に含まれるマニュアルページ数が妥当か確認
- [ ] bsd.man.mkのインストールルール（圧縮、シンボリックリンク等）が正確か確認
- [ ] man3luaセクションの対象ライブラリが網羅されているか確認
