---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：11-UFS_FFS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：定量的なベンチマーク根拠なし
  2. **SUJデフォルト有効の記述**：バージョンによる差異の可能性
  3. **スナップショット機能の詳細**：ffs_snapshot.cの詳細解析未実施

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/ufs/ffs/fs.h` - スーパーブロック構造体定義（340行目 struct fs）
- E-02: `sys/ufs/ufs/inode.h` - inode構造体定義（79行目 struct inode）
- E-03: `sys/ufs/ffs/ffs_vfsops.c` - VFS操作実装（ffs_mount 347行目, ffs_mountfs 869行目）
- E-04: `sys/ufs/ffs/ffs_alloc.c` - ブロック割り当て（ffs_alloc 150行目, ffs_valloc 1111行目）
- E-05: `sys/ufs/ufs/ufs_vnops.c` - vnode操作実装
- E-06: `sys/ufs/ffs/ffs_softdep.c` - ソフトアップデート実装
- E-07: `sbin/newfs/newfs.c` - newfsコマンド（main 118行目）
- E-08: `sbin/fsck_ffs/main.c` - fsckメイン（main 67行目）
- E-09: `sbin/dump/main.c` - dumpコマンド
- E-10: `sbin/restore/main.c` - restoreコマンド
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連情報
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | struct fs がスーパーブロック構造体として340行目に定義 | E-01 | ○ |
| C-02 | struct inode が79行目に定義 | E-02 | ○ |
| C-03 | VTOI マクロが262行目に定義 | E-02 | ○ |
| C-04 | ffs_mount が347行目に定義 | E-03 | ○ |
| C-05 | ffs_mountfs が869行目に定義 | E-03 | ○ |
| C-06 | ffs_unmount が1226行目に定義 | E-03 | ○ |
| C-07 | ffs_statfs が1425行目に定義 | E-03 | ○ |
| C-08 | ffs_sync が1540行目に定義 | E-03 | ○ |
| C-09 | VFS_SET で ufs として登録（118行目） | E-03 | ○ |
| C-10 | ffs_alloc が150行目に定義 | E-04 | ○ |
| C-11 | ffs_valloc が1111行目に定義 | E-04 | ○ |
| C-12 | ffs_blkfree が2671行目に定義 | E-04 | ○ |
| C-13 | ffs_vfree が2820行目に定義 | E-04 | ○ |
| C-14 | newfs main が118行目に定義 | E-07 | ○ |
| C-15 | fsck_ffs main が67行目に定義 | E-08 | ○ |
| C-16 | SBLOCK_UFS2=65536, SBLOCK_UFS1=8192 等の定数 | E-01 | ○ |
| C-17 | I_IS_UFS1/I_IS_UFS2 が216/223行目に定義 | E-02 | ○ |
| C-18 | パーティションモード選択画面(No.15)との関連 | E-11 | ○ |
| C-19 | 手動パーティション編集画面(No.17)との関連 | E-11 | ○ |
| C-20 | ソフトアップデートによるメタデータ一貫性保証 | E-06 | ○ |
| C-21 | dump/restoreコマンドの存在 | E-09, E-10 | ○ |
| C-22 | UFS_DIRHASHによるディレクトリハッシュ機能 | E-05 | ○ |
| C-23 | SUJがデフォルト有効という記述 | **根拠なし** | △ |
| C-24 | パフォーマンス要件の具体的記述 | **根拠なし** | △ |
| C-25 | スナップショット機能によるオンラインfsck | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SUJのデフォルト設定はnewfsのデフォルト引数やカーネルコンフィグに依存するため、バージョンごとの確認が必要
  - 候補：`sbin/newfs/newfs.c` のデフォルト値 / `sys/ufs/ffs/ffs_softdep.c` の初期化コード / release notes
- パフォーマンスの定量値はベンチマーク結果に依存
  - 候補：FreeBSD性能テスト結果 / 外部ベンチマーク文献
- スナップショット機能の詳細はffs_snapshot.cの解析が必要
  - 候補：`sys/ufs/ffs/ffs_snapshot.c` / mksnap_ffs(8) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードリーディングガイドの行番号は実ソースから取得しており正確
- 0: 低リスク - データ構造定義はヘッダファイルから直接確認
- 1: 中リスク - SUJデフォルト設定に関する記述はバージョン依存の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] スーパーブロック構造体の記述がfs.hの実際の定義と一致するか
- [ ] VFS操作関数の行番号が現在のソースと一致するか
- [ ] 画面機能マッピングの関連が正しいか（画面No.15, 17）
- [ ] SUJデフォルト有効の記述が使用バージョンに適合するか
- [ ] エラーコード一覧が実装と一致するか
