---
generated_at: 2026-02-01 11:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：110-国際化・地域化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **mapper.dir.srcの詳細形式**: 変換ルーティング定義の正確な形式は未検証
  2. **charset.pivot.srcの詳細形式**: ピボット定義の正確な形式は未検証
  3. **ロケールデータのコンパイルプロセス**: *.srcからバイナリへの変換ツールの詳細は未検証

## 2) 参照した情報（Evidence一覧）
- E-01: `share/i18n/` (ディレクトリ一覧)
- E-02: `share/i18n/csmapper/` (csmapperサブディレクトリ一覧)
- E-03: `share/i18n/esdb/` (esdbサブディレクトリ一覧)
- E-04: `share/colldef/` (照合順序定義一覧)
- E-05: `share/monetdef/` (通貨形式定義一覧)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (画面機能マッピング)
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` (機能一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | csmapperとesdbの2つのサブディレクトリが存在 | E-01 (ディレクトリ一覧) | ○ |
| C-02 | csmapperにAPPLE, AST, BIG5, CNS, CP, EBCDIC, GB, GEORGIAN, ISO-8859, ISO646, JIS, KAZAKH, KOI, KSサブディレクトリ | E-02 | ○ |
| C-03 | esdbにAPPLE, AST, BIG5, CP, DEC, EBCDIC, EUC, GB, GEORGIAN, ISO-2022, ISO-8859, ISO646, KAZAKH, KOI, MISC, TCVNサブディレクトリ | E-03 | ○ |
| C-04 | mapper.dir.srcとcharset.pivot.srcが存在 | E-02 (ディレクトリ一覧) | ○ |
| C-05 | colldefに各ロケール固有の*.srcファイルが存在 | E-04 (af_ZA, be_BY, ja_JP等) | ○ |
| C-06 | monetdefに各ロケール固有の*.srcファイルが存在 | E-05 (en_US, en_GB, be_BY等) | ○ |
| C-07 | 画面1「キーマップ選択画面」との関連 | E-06 (3行目) | ○ |
| C-08 | 画面7「無線LAN設定画面」との関連 | E-06 (13行目) | ○ |
| C-09 | Makefile, Makefile.inc, Makefile.partが存在 | E-02 (ディレクトリ一覧) | ○ |
| C-10 | ja_JP.eucJP.src等の照合順序定義が存在 | E-04 | ○ |
| C-11 | UCSピボットによる文字コード変換モデル | E-07 (i18n一般知識) | ○ |
| C-12 | mapper.dir.srcの正確な形式 | **根拠なし** | △ |
| C-13 | charset.pivot.srcの正確な形式 | **根拠なし** | △ |
| C-14 | *.srcからバイナリへのコンパイルツール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- mapper.dir.src、charset.pivot.srcの内容は未読み込みのため、正確なフォーマットが未検証
  - 候補：mapper.dir.src、charset.pivot.srcの読み込み
- *.srcファイルからバイナリデータへのコンパイルに使用されるツール（mkesdb, mkcsmapper等）の詳細は未検証
  - 候補：usr.bin/mkesdb、usr.bin/mkcsmapperの確認
- 各ロケール定義ファイルの内部形式の詳細は未検証
  - 候補：colldef(1)、monetdef(5)のmanページ参照

## 5) リスクフラグ（レビュー観点）
- 0: ディレクトリ構造とファイル存在は確認済み
- 0: 画面機能マッピングとの関連は確認済み
- 1: ソースファイル形式の詳細は中リスク
- 1: コンパイルプロセスの詳細は中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] mapper.dir.srcの形式が設計書の記述と一致するか確認
- [ ] csmapperのピボット変換モデルが実装と一致するか確認
- [ ] ビルドプロセス（mkesdb, mkcsmapper等）が正確に記述されているか確認
- [ ] サポートされるエンコーディングの一覧が網羅的か確認
