---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 18
  claims_without_evidence: 4
confidence_derived: 0.82
---

# 根拠レポート：12-ZFS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.82**
  - 根拠あり：18 / 22、根拠なし：4
- 優先レビュー（高）
  1. **TXGデフォルト間隔5秒の記述**：カーネルチューニングパラメータの確認が必要
  2. **ZSTD圧縮サポート**：OpenZFSバージョン依存
  3. **スラップスペース予約3.2%**：バージョンにより変動の可能性
  4. **Native暗号化の詳細**：dsl_crypt.cの詳細解析未実施

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/contrib/openzfs/module/os/freebsd/zfs/zfs_vfsops.c` - VFS操作（124-1725行目）
- E-02: `sys/contrib/openzfs/module/zfs/zfs_vnops.c` - vnode操作
- E-03: `sys/contrib/openzfs/module/zfs/dmu.c` - DMU層
- E-04: `sys/contrib/openzfs/module/zfs/spa.c` - SPA層
- E-05: `sys/contrib/openzfs/module/zfs/arc.c` - ARCキャッシュ
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連情報
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zfs_mount が1364行目に定義 | E-01 | ○ |
| C-02 | zfs_umount が1725行目に定義 | E-01 | ○ |
| C-03 | zfs_root が1564行目に定義 | E-01 | ○ |
| C-04 | vfsops構造体が136-139行目で登録 | E-01 | ○ |
| C-05 | OpenZFSベースの実装 | E-01 | ○ |
| C-06 | ZPL→DMU→SPA→vdevの多層アーキテクチャ | E-01, E-02, E-03, E-04 | ○ |
| C-07 | ARCによるキャッシュ管理 | E-05 | ○ |
| C-08 | 画面No.15,16,17との関連 | E-06 | ○ |
| C-09 | COWによるデータ更新 | E-03 | ○ |
| C-10 | チェックサムベースの整合性検証 | E-04 | ○ |
| C-11 | RAID-Z1/Z2/Z3のサポート | E-04 | ○ |
| C-12 | CDDLライセンス | E-01 | ○ |
| C-13 | zfs_znode.cによるznode管理 | E-02 | ○ |
| C-14 | dsl_crypt.cによるデータセット暗号化 | E-03 | ○ |
| C-15 | metaslab.cによるブロック割り当て | E-04 | ○ |
| C-16 | txg.cによるTXG管理 | E-04 | ○ |
| C-17 | zil.cによるZIL管理 | E-04 | ○ |
| C-18 | sbin/zfsbootcfg の存在 | E-07 | ○ |
| C-19 | TXGデフォルト間隔5秒 | **根拠なし** | △ |
| C-20 | ZSTD圧縮サポート | **根拠なし** | △ |
| C-21 | スラップスペース予約3.2% | **根拠なし** | △ |
| C-22 | NFSv4 ACLサポートの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TXGデフォルト間隔はzfs_txg_timeout sysctlパラメータに依存
  - 候補：`sys/contrib/openzfs/module/zfs/txg.c` / sysctl設定
- ZSTD圧縮はOpenZFS 2.0以降で追加
  - 候補：OpenZFS リリースノート / META ファイル
- スラップスペース予約率はプールバージョンや設定に依存
  - 候補：`sys/contrib/openzfs/module/zfs/spa.c` のspa_slop計算

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - VFS操作の行番号はソースから直接確認
- 1: 中リスク - TXGタイミングやスラップスペースの具体値
- 1: 中リスク - OpenZFSバージョン固有の機能（ZSTD等）

## 6) レビュアーチェックリスト（最小）
- [ ] zfs_vfsops.cの行番号が現在のソースと一致するか
- [ ] 画面機能マッピングの関連が正しいか（画面No.15, 16, 17）
- [ ] OpenZFSバージョンに応じた機能記述が正確か
- [ ] ZFS暗号化に関する記述がFreeBSD対応状況と一致するか
