---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：13-NFS

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **NFSv4.2サポート状況**：バージョン固有の確認が必要
  2. **pNFSサーバ側サポート**：実装状況の確認が必要
  3. **デフォルトrsize/wsize値**：バージョン依存の可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/fs/nfsclient/nfs_clvfsops.c` - VFS操作（123-156行目）
- E-02: `sys/fs/nfsclient/` - クライアントソースディレクトリ
- E-03: `sys/fs/nfs/` - 共通ソースディレクトリ
- E-04: `sys/fs/nfsserver/` - サーバソースディレクトリ
- E-05: `sbin/mount_nfs/mount_nfs.c` - mount_nfsコマンド
- E-06: `sbin/nfsiod/nfsiod.c` - nfsiodデーモン
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | nfs_mount が123行目に宣言 | E-01 | ○ |
| C-02 | nfs_unmount が125行目に宣言 | E-01 | ○ |
| C-03 | VFS_SET でnfsとして156行目に登録 | E-01 | ○ |
| C-04 | VFCF_NETWORK フラグ | E-01 | ○ |
| C-05 | クライアントソースがsys/fs/nfsclient/に存在 | E-02 | ○ |
| C-06 | 共通ソースがsys/fs/nfs/に存在 | E-03 | ○ |
| C-07 | サーバソースがsys/fs/nfsserver/に存在 | E-04 | ○ |
| C-08 | mount_nfs.cの存在 | E-05 | ○ |
| C-09 | nfsiod.cの存在 | E-06 | ○ |
| C-10 | nfs_cl*プレフィクスのファイル命名規則 | E-02 | ○ |
| C-11 | nfs_nfsd*プレフィクスのファイル命名規則 | E-04 | ○ |
| C-12 | nfsproto.hにプロトコル定義 | E-03 | ○ |
| C-13 | nfs_clstate.cによるNFSv4状態管理 | E-02 | ○ |
| C-14 | nfs_nfsdcache.cによるサーバ応答キャッシュ | E-04 | ○ |
| C-15 | nfs_commonkrpc.cによる共通RPC通信 | E-03 | ○ |
| C-16 | nfs_commonsubs.cによる共通サブルーチン | E-03 | ○ |
| C-17 | 画面関連なしの記述 | E-07 | ○ |
| C-18 | NFSv4.2サポート | **根拠なし** | △ |
| C-19 | pNFSサーバ側サポート状況 | **根拠なし** | △ |
| C-20 | デフォルトrsize/wsize=65536 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NFSv4.2サポートの詳細はプロトコルバージョン検出コードの確認が必要
  - 候補：`sys/fs/nfs/nfsproto.h` / `sys/fs/nfsclient/nfs_clrpcops.c`
- pNFSサーバ側実装状況はサーバコードの詳細解析が必要
  - 候補：`sys/fs/nfsserver/nfs_nfsdserv.c` のpNFS関連関数
- rsize/wsizeのデフォルト値はmount_nfs.cの解析が必要
  - 候補：`sbin/mount_nfs/mount_nfs.c` のデフォルトパラメータ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースディレクトリ構成は実際のファイル一覧から確認
- 0: 低リスク - VFS操作の行番号はgrepで確認
- 1: 中リスク - NFSバージョン固有機能の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] nfs_clvfsops.cの行番号が現在のソースと一致するか
- [ ] NFSバージョンサポートの記述が正確か
- [ ] サーバ側デーモン構成の記述が正確か
- [ ] セキュリティ関連（Kerberos連携）の記述が実装と一致するか
