---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：14-msdosfs（FAT）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **FAT種別判定のクラスタ閾値**：Microsoft仕様との整合確認
  2. **exFATサポート状況**：fusefs-exfat以外の選択肢の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/fs/msdosfs/msdosfs_vfsops.c` - VFS操作（231行目 msdosfs_mount, 1205行目 VFS_SET）
- E-02: `sys/fs/msdosfs/` - ソースディレクトリ一覧
- E-03: `sys/fs/msdosfs/bpb.h` - BPB構造体
- E-04: `sys/fs/msdosfs/denode.h` - denode構造体
- E-05: `sys/fs/msdosfs/direntry.h` - ディレクトリエントリ形式
- E-06: `sbin/mount_msdosfs/mount_msdosfs.c` - mountコマンド
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | msdosfs_mount が231行目に定義 | E-01 | ○ |
| C-02 | msdosfs_unmount が891行目に定義 | E-01 | ○ |
| C-03 | VFS_SET が1205行目に登録 | E-01 | ○ |
| C-04 | BPB構造体がbpb.hに定義 | E-03 | ○ |
| C-05 | denode構造体がdenode.hに定義 | E-04 | ○ |
| C-06 | ディレクトリエントリ形式がdirentry.hに定義 | E-05 | ○ |
| C-07 | mount_msdosfs.cの存在 | E-06 | ○ |
| C-08 | msdosfs_fat.c, msdosfs_lookup.c等のソースファイル | E-02 | ○ |
| C-09 | msdosfs_conv.c, msdosfs_iconv.cによる文字コード変換 | E-02 | ○ |
| C-10 | FAT12/FAT16/FAT32のサポート | E-01 | ○ |
| C-11 | VFATサポート | E-05 | ○ |
| C-12 | fsck_msdosfsの存在 | E-07 | ○ |
| C-13 | newfs_msdosの存在 | E-07 | ○ |
| C-14 | msdosfsmount.hにマウント情報構造体 | E-02 | ○ |
| C-15 | fat.hにFATテーブル操作定義 | E-02 | ○ |
| C-16 | bootsect.hにブートセクタ定義 | E-02 | ○ |
| C-17 | FAT種別判定のクラスタ閾値（4085/65525） | **根拠なし** | △ |
| C-18 | exFATサポート状況の記述 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FAT種別判定の具体的閾値はMicrosoft FAT仕様書で定義されるが、実装コードでの確認が必要
  - 候補：`sys/fs/msdosfs/msdosfs_vfsops.c` のマウント処理中のFAT判定ロジック
- exFATサポートはports/pkgのfusefs-exfatに依存
  - 候補：FreeBSD Ports Collection / pkg情報

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - VFS操作の行番号はgrepで確認済み
- 0: 低リスク - ソースファイル一覧はlsで確認済み
- 1: 中リスク - FAT種別判定閾値の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] msdosfs_vfsops.cの行番号が現在のソースと一致するか
- [ ] FAT種別判定ロジックがMicrosoft仕様と一致するか
- [ ] 文字コード変換の詳細が正確か
- [ ] EFIシステムパーティションへの言及が正確か
