---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：21-devfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **devfs_dir.cの詳細処理内容**：ファイル読解が限定的
  2. **PRIV_DEVFS_RULE権限の詳細動作**：権限チェック箇所の特定が不完全

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/fs/devfs/devfs.h` - データ構造定義（devfs_rule, devfs_dirent, devfs_mount）
- E-02: `sys/fs/devfs/devfs_vfsops.c` - VFS操作実装（mount/unmount/root/statfs）
- E-03: `sys/fs/devfs/devfs_vnops.c` - vnodeオペレーション実装
- E-04: `sys/fs/devfs/devfs_rule.c` - ルールセット実装
- E-05: `sys/fs/devfs/devfs_devs.c` - デバイスノード管理
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devfsは擬似ファイルシステムでデバイスファイルを動的管理 | E-06 | ○ |
| C-02 | devfs_mount構造体のフィールド定義（dm_idx, dm_lock等） | E-01 (160-168行目) | ○ |
| C-03 | devfs_dirent構造体のフィールド定義（de_flags, de_mode等） | E-01 (129-155行目) | ○ |
| C-04 | devfs_rule構造体のフィールド定義（dr_magic, dr_id等） | E-01 (66-100行目) | ○ |
| C-05 | マウント時にjail判定しpr_devfs_rsnumを強制適用 | E-02 (83, 100-107行目) | ○ |
| C-06 | ルールセット番号は0-65535の範囲 | E-02 (94行目) | ○ |
| C-07 | MNT_ROOTFSはEOPNOTSUPP | E-02 (79-80行目) | ○ |
| C-08 | exportオプションはEOPNOTSUPP | E-02 (89-90行目) | ○ |
| C-09 | statfsでブロックサイズDEV_BSIZE、ブロック数2を返却 | E-02 (226-234行目) | ○ |
| C-10 | VFS_SETでVFCF_SYNTHETIC, VFCF_JAILフラグ登録 | E-02 (244行目) | ○ |
| C-11 | cdevp_listがグローバルデバイスリスト | E-05 (55行目) | ○ |
| C-12 | devfs_generationでデバイス変更検出 | E-05 (66-68行目) | ○ |
| C-13 | devfs_rule_depthのデフォルト値は1 | E-05 (70行目) | ○ |
| C-14 | devfs_krule構造体の定義 | E-04 (82-86行目) | ○ |
| C-15 | devfs_ruleset構造体の定義 | E-04 (94-99行目) | ○ |
| C-16 | ルールのapplyとrunの区別 | E-04 (29-34行目コメント) | ○ |
| C-17 | rid = rn | (rsn << 16) のルールID計算式 | E-01 (57-59行目) | ○ |
| C-18 | ioctl定義（DEVFSIO_RADD等） | E-01 (105-113行目) | ○ |
| C-19 | devfs_dir.cのディレクトリ操作詳細 | **根拠なし** | △ |
| C-20 | PRIV_DEVFS_RULEによるルール操作制限の具体的実装箇所 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- devfs_dir.cの内容は今回の読み込み対象外であり、ディレクトリ操作の詳細実装は未確認
  - 候補：devfs_dir.c全体の読解 / devfs_vnops.cのreaddir実装確認
- PRIV_DEVFS_RULEの権限チェック箇所はdevfs_rule.c内にあると推定されるが、該当行の特定が不完全
  - 候補：devfs_rule.c全体の読解 / priv(9)マニュアル参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要データ構造とVFS操作は十分なエビデンスで裏付け
- 1: 中リスク - devfs_dir.cの詳細が未確認（機能網羅性に影響の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] devfs_dir.cの処理内容がドキュメントと矛盾しないか確認
- [ ] jail環境でのルールセット強制適用の動作が正確に記述されているか確認
- [ ] MACフレームワーク統合の詳細が必要か判断
