---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：22-autofs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **autofs.cのtrigger/cached実装詳細**：本体ロジックの読解が限定的
  2. **autofs_ioctl.hのインタフェース定義**：ioctl定義の確認が未完了

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/fs/autofs/autofs.h` - データ構造定義
- E-02: `sys/fs/autofs/autofs_vfsops.c` - VFS操作実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | autofsはオンデマンドで自動マウントする機構 | E-03 | ○ |
| C-02 | autofs_node構造体の定義（RB-tree、an_cached等） | E-01 (68-83行目) | ○ |
| C-03 | autofs_mount構造体の定義（am_from等MAXPATHLEN配列） | E-01 (85-95行目) | ○ |
| C-04 | autofs_request構造体の定義（ar_done、ar_error等） | E-01 (97-112行目) | ○ |
| C-05 | autofs_softc構造体の定義（sc_cdev、sc_cv等） | E-01 (114-123行目) | ○ |
| C-06 | マウントオプションはfrom、master_options、master_prefix | E-02 (49-51行目) | ○ |
| C-07 | MNT_UPDATE時にautofs_flushを呼び出し | E-02 (65-67行目) | ○ |
| C-08 | マウント時にautofs_node_newでルートノード作成 | E-02 (99行目) | ○ |
| C-09 | アンマウント時に未処理リクエストをENXIOでキャンセル | E-02 (137-154行目) | ○ |
| C-10 | ノードツリーの非再帰的削除 | E-02 (161-167行目) | ○ |
| C-11 | VFCF_SYNTHETICとVFCF_NETWORKフラグ | E-02 (217行目) | ○ |
| C-12 | MODULE_VERSION(autofs, 1) | E-02 (218行目) | ○ |
| C-13 | statfsでf_blocks=0を返却 | E-02 (198行目) | ○ |
| C-14 | MNTK_LOOKUP_SHAREDカーネルフラグ設定 | E-02 (95行目) | ○ |
| C-15 | an_retriesカウンタによるリトライ管理 | E-01 (81行目) | ○ |
| C-16 | an_calloutによるタイムアウト管理 | E-01 (80行目) | ○ |
| C-17 | autofs.cのtrigger/cached実装詳細 | **根拠なし** | △ |
| C-18 | autofs_ioctl.hのioctl定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- autofs.cの本体ロジック（autofs_trigger、autofs_cached関数の実装詳細）は未読解
  - 候補：autofs.c全体の読解 / automountdソースとの照合
- autofs_ioctl.hのioctl定義詳細は未確認
  - 候補：autofs_ioctl.h / usr.sbin/autofs/のユーザランドコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造とVFS操作は十分に裏付けされている
- 1: 中リスク - トリガ機構の詳細実装が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] autofs.cのautofs_trigger()実装がドキュメントと整合するか確認
- [ ] automountdとの通信プロトコル詳細が正確か確認
- [ ] キャッシュ無効化条件が網羅されているか確認
