---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：26-GEOMストレージフレームワーク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **g_io_request/g_io_deliverの詳細実装**：geom_io.c未読解
  2. **イベントシステムの詳細**：geom_event.c未読解
  3. **gctl制御インタフェースの詳細**：geom_ctl.c未読解

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/geom/geom.h` - 基本データ構造定義（冒頭100行）
- E-02: `sys/geom/` ディレクトリ内ファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GEOMはディスクI/O変換のモジュラーフレームワーク | E-03 | ○ |
| C-02 | g_class構造体の定義（name, taste, ctlreq等） | E-01 (93-100行目) | ○ |
| C-03 | コールバック型定義（g_taste_t, g_start_t等） | E-01 (62-84行目) | ○ |
| C-04 | G_TF_NORMAL/G_TF_INSIST/G_TF_TRANSPARENTフラグ | E-01 (71-73行目) | ○ |
| C-05 | DARPA/SPAWAR契約で開発 | E-01 (著作権表示8-11行目) | ○ |
| C-06 | サブクラス一覧（cache, concat, eli等） | E-02 | ○ |
| C-07 | 画面15,16,17との関連 | E-04 | ○ |
| C-08 | g_config_t型定義 | E-01 (62行目) | ○ |
| C-09 | g_ctl_req_t型定義 | E-01 (63行目) | ○ |
| C-10 | g_ctl_create_geom_t型定義 | E-01 (64行目) | ○ |
| C-11 | g_ctl_destroy_geom_t型定義 | E-01 (65行目) | ○ |
| C-12 | g_access_t型定義 | E-01 (74行目) | ○ |
| C-13 | g_orphan_t型定義 | E-01 (76行目) | ○ |
| C-14 | g_dumpconf_t型定義 | E-01 (82-83行目) | ○ |
| C-15 | g_resize_t型定義 | E-01 (84行目) | ○ |
| C-16 | g_io_request/g_io_deliverの詳細動作 | **根拠なし** | △ |
| C-17 | イベントシステムの詳細動作 | **根拠なし** | △ |
| C-18 | gctl制御インタフェースの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- geom_io.c, geom_event.c, geom_ctl.cの実装詳細は未読解
  - 候補：各ファイルの全体読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本データ構造とアーキテクチャは十分に裏付け
- 1: 中リスク - I/O処理パスとイベントシステムの詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] geom_io.cのBIO処理パスがドキュメントと整合するか確認
- [ ] イベントシステムの動作が正確に記述されているか確認
- [ ] サブクラス一覧が最新か確認
