---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：27-GEOM ELI（ディスク暗号化）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **g_eli.cのBIO処理詳細**：メイン実装の読解が限定的
  2. **g_eli_privacy.cの暗号化処理詳細**：暗号化パスの読解が限定的
  3. **g_eli_ctl.cの制御操作詳細**：ユーザ空間インタフェースの読解が限定的

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/geom/eli/g_eli.h` - データ構造・フラグ定義（冒頭100行）
- E-02: `sys/geom/eli/` ディレクトリ内ファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GEOMベースのディスク暗号化 | E-03 | ○ |
| C-02 | G_ELI_CLASS_NAME = "ELI" | E-01 (57行目) | ○ |
| C-03 | G_ELI_MAGIC = "GEOM::ELI" | E-01 (58行目) | ○ |
| C-04 | G_ELI_SUFFIX = ".eli" | E-01 (59行目) | ○ |
| C-05 | バージョン履歴v0-v7 | E-01 (62-84行目) | ○ |
| C-06 | G_ELI_FLAG_ONETIME | E-01 (88行目) | ○ |
| C-07 | G_ELI_FLAG_BOOT | E-01 (90行目) | ○ |
| C-08 | G_ELI_FLAG_WO_DETACH/RW_DETACH | E-01 (92-94行目) | ○ |
| C-09 | G_ELI_FLAG_AUTH | E-01 (96行目) | ○ |
| C-10 | G_ELI_FLAG_RO | E-01 (98行目) | ○ |
| C-11 | G_ELI_FLAG_NODELETE | E-01 (100行目) | ○ |
| C-12 | OpenCrypto/cryptodev.h使用 | E-01 (37行目) | ○ |
| C-13 | SHA256/SHA512使用 | E-01 (35-36行目) | ○ |
| C-14 | 画面16との関連 | E-04 | ○ |
| C-15 | Pawel Jakub Dawidekによる開発 | E-01 (著作権) | ○ |
| C-16 | g_eli.cのBIO処理の詳細 | **根拠なし** | △ |
| C-17 | AES-XTS暗号化の詳細実装 | **根拠なし** | △ |
| C-18 | gctl制御操作の詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- g_eli.c, g_eli_privacy.c, g_eli_ctl.cの実装詳細は未読解
  - 候補：各ファイルの全体読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ定義とバージョン管理は十分に裏付け
- 1: 中リスク - 暗号化処理パスの詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] AES-XTS暗号化の具体的な実装がドキュメントと整合するか確認
- [ ] 鍵管理のセキュリティ要件が正確に記述されているか確認
- [ ] パフォーマンスに関する記述が現実的か確認
