---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：28-GEOMミラー・ストライプ・RAID

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **g_mirror.cのBIO処理とbalanceアルゴリズム詳細**
  2. **g_stripe.cのストライプI/O分散処理詳細**
  3. **同期処理の詳細フロー**

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/geom/mirror/g_mirror.h` - ミラー構造体・フラグ定義（冒頭80行）
- E-02: `sys/geom/mirror/`, `sys/geom/stripe/`, `sys/geom/raid/`, `sys/geom/raid3/` ファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソフトウェアRAID（ミラーリング・ストライピング・RAID3等） | E-03 | ○ |
| C-02 | G_MIRROR_CLASS_NAME = "MIRROR" | E-01 (35行目) | ○ |
| C-03 | G_MIRROR_MAGIC = "GEOM::MIRROR" | E-01 (37行目) | ○ |
| C-04 | G_MIRROR_VERSION = 4 | E-01 (46行目) | ○ |
| C-05 | 5種類のbalanceアルゴリズム | E-01 (48-54行目) | ○ |
| C-06 | ディスクフラグ定義（DIRTY, SYNCHRONIZING等） | E-01 (56-62行目) | ○ |
| C-07 | デバイスフラグ（NOAUTOSYNC, NOFAILSYNC） | E-01 (71-72行目) | ○ |
| C-08 | CANDELETEフラグ | E-01 (62行目) | ○ |
| C-09 | 6種類のRAIDメタデータドライバ | E-02 | ○ |
| C-10 | RAID変換モジュール（raid0/1/1e/5/concat） | E-02 | ○ |
| C-11 | ファイル構成（mirror 3ファイル, stripe 2ファイル, raid3 3ファイル, raid 17ファイル） | E-02 | ○ |
| C-12 | MD5ハッシュによるメタデータ検証 | E-01 (33行目 sys/md5.h include) | ○ |
| C-13 | DISK_FLAG_MASK定義 | E-01 (65-69行目) | ○ |
| C-14 | g_mirror.cのBIO処理詳細 | **根拠なし** | △ |
| C-15 | ストライプI/O分散の具体的実装 | **根拠なし** | △ |
| C-16 | 同期処理の詳細フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- g_mirror.c, g_stripe.cの実装詳細は未読解
  - 候補：各ファイルの全体読解
- 同期処理（sync thread）の詳細フローは推定ベース
  - 候補：g_mirror.cの同期関連コード読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フラグ定義とファイル構成は確認済み
- 1: 中リスク - I/O処理パスと同期処理の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] balanceアルゴリズムの実装がドキュメントと整合するか確認
- [ ] 同期処理の実装が正確に記述されているか確認
- [ ] graidのメタデータ自動認識動作を確認
