---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：29-GEOMゲートウェイ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **g_gate.cのBIOディスパッチとioctl処理詳細**

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/geom/gate/g_gate.h` - 全データ構造・ioctl定義（全162行）
- E-02: `sys/geom/gate/` ディレクトリ内ファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネットワーク経由でブロックデバイスをエクスポート | E-03 | ○ |
| C-02 | G_GATE_CLASS_NAME = "GATE" | E-01 (39行目) | ○ |
| C-03 | G_GATE_VERSION = 3 | E-01 (44行目) | ○ |
| C-04 | G_GATE_MAX_QUEUE_SIZE = 4096 | E-01 (50行目) | ○ |
| C-05 | READONLY/WRITEONLY/DESTROYフラグ | E-01 (52-55行目) | ○ |
| C-06 | G_GATE_UNIT_AUTO = -1, G_GATE_NAME_GIVEN = -2 | E-01 (60-64行目) | ○ |
| C-07 | 6つのioctlコマンド（CREATE/MODIFY/DESTROY/CANCEL/START/DONE） | E-01 (66-71行目) | ○ |
| C-08 | g_gate_softc構造体（sc_inqueue, sc_outqueue等） | E-01 (79-101行目) | ○ |
| C-09 | g_gate_ctl_create構造体 | E-01 (109-121行目) | ○ |
| C-10 | g_gate_ctl_modify構造体（GG_MODIFY_*フラグ） | E-01 (123-135行目) | ○ |
| C-11 | g_gate_ctl_destroy構造体 | E-01 (137-142行目) | ○ |
| C-12 | g_gate_ctl_cancel構造体 | E-01 (144-149行目) | ○ |
| C-13 | g_gate_ctl_io構造体 | E-01 (151-160行目) | ○ |
| C-14 | G_GATE_INFOSIZE = 2048 | E-01 (73行目) | ○ |
| C-15 | ggatec/ggated/ggatel サブディレクトリ | E-02 | ○ |
| C-16 | g_gate.cのBIOディスパッチ詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- g_gate.cの実装詳細は未読解
  - 候補：g_gate.c全体の読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ヘッダファイルの全構造が確認済みで高い信頼度

## 6) レビュアーチェックリスト（最小）
- [ ] g_gate.cのioctl処理がドキュメントと整合するか確認
- [ ] ネットワークプロトコルの詳細が必要か判断
