---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：30-CAMストレージサブシステム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **cam_xpt.cのXPTコア実装**：中核ロジックの読解が限定的
  2. **cam_ccb.hのCCB定義**：CCB構造の全体把握が未完了
  3. **cam_periph.cのエラーリカバリ**：リトライ処理の詳細未確認
  4. **cam_iosched.cのスケジューリング**：I/Oスケジューラの詳細未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `sys/cam/cam.h` - 基本型・定数定義（冒頭100行）
- E-02: `sys/cam/` ディレクトリ内ファイル一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCSI/ATA/NVMe等の共通アクセス層 | E-03 | ○ |
| C-02 | path_id_t, target_id_t, lun_id_t型定義 | E-01 (46-48行目) | ○ |
| C-03 | ワイルドカード定数（CAM_BUS_WILDCARD等） | E-01 (50-53行目) | ○ |
| C-04 | CAM_EXTLUN_BYTE_SWIZZLEマクロ | E-01 (55-59行目) | ○ |
| C-05 | CAM_MAX_CDBLEN = 16 | E-01 (64行目) | ○ |
| C-06 | cam_rl優先度列挙（HOST/BUS/XPT/DEV/NORMAL） | E-01 (77-84行目) | ○ |
| C-07 | cam_pinfo構造体（priority, generation, index） | E-01 (89-100行目) | ○ |
| C-08 | CAM_PRIORITY_*マクロ定義 | E-01 (91-97行目) | ○ |
| C-09 | CAM_UNQUEUED_INDEX = -1 | E-01 (100行目) | ○ |
| C-10 | サブディレクトリ構成（ata, ctl, mmc, nvme, scsi） | E-02 | ○ |
| C-11 | README.quirksファイル | E-02 | ○ |
| C-12 | cam_iosched.cファイル存在 | E-02 | ○ |
| C-13 | cam_compat.cファイル存在 | E-02 | ○ |
| C-14 | Justin T. Gibbsによる開発 | E-01 (著作権) | ○ |
| C-15 | cam_xpt.cのXPTコア実装詳細 | **根拠なし** | △ |
| C-16 | cam_ccb.hのCCB定義の詳細 | **根拠なし** | △ |
| C-17 | cam_periph.cのエラーリカバリ詳細 | **根拠なし** | △ |
| C-18 | cam_iosched.cのスケジューリング詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cam_xpt.c, cam_ccb.h, cam_periph.c, cam_iosched.cの実装詳細は未読解
  - 候補：各ファイルの全体読解

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - CAMはFreeBSDストレージスタックの中核であり、XPT処理パスの詳細が重要
- 0: 低リスク - 基本データ型とアーキテクチャ概要は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cam_xpt.cのxpt_action/xpt_doneの実装を確認
- [ ] CCB構造の全体把握（union ccbの各メンバー）
- [ ] エラーリカバリフローが正確か確認
- [ ] SCSI/ATA/NVMe各プロトコルの統合方式を確認
