---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-mdデバイス（メモリディスク）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **カーネル側md(4)ドライバの詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/mdconfig/mdconfig.c` - mdconfigメインソース
- E-02: `sbin/mdmfs/mdmfs.c` - mdmfsメインソース
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.32）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | mdconfigはmd(4)デバイスの作成・削除・リサイズ・一覧を行う | E-01 (58行目 enum action) | ○ |
| C-02 | 4つのタイプ（malloc/vnode/swap/null）をサポート | E-01 (154-166行目) | ○ |
| C-03 | geom_mdモジュールのロード確認を行う | E-01 (370-371行目) | ○ |
| C-04 | /dev/mdctlデバイスをO_RDWRでオープン | E-01 (373行目) | ○ |
| C-05 | MDIOCATTACH/MDIOCDETACH/MDIOCRESIZEの3つのioctlを使用 | E-01 (378, 386, 392行目) | ○ |
| C-06 | GEOMライブラリで一覧取得する | E-01 (509-516行目 geom_gettree, geom_stats_open) | ○ |
| C-07 | タイプ推論ロジック（-f→vnode, -s→swap） | E-01 (282-296行目) | ○ |
| C-08 | 読み取り専用自動設定 | E-01 (313-320行目) | ○ |
| C-09 | MD_AUTOUNITフラグによる自動ユニット番号割り当て | E-01 (156行目等) | ○ |
| C-10 | mdmfsはmdconfig+newfs+mountのラッパー | E-02 (29-33行目コメント) | ○ |
| C-11 | mdmfs autoモードでtmpfsフォールバック | E-02 (310-319行目) | ○ |
| C-12 | mount_mfs互換モード | E-02 (136-141行目) | ○ |
| C-13 | mdmfsのrun()でfork+execvによるヘルパー呼び出し | E-02 (715-812行目) | ○ |
| C-14 | サイズサフィックスの解析ロジック | E-01 (232-250行目), E-02 (270-299行目) | ○ |
| C-15 | mdmfsのオプション群（-S softdep, -P no-newfs等） | E-02 (143-256行目) | ○ |
| C-16 | swapタイプのメモリディスクはゼロクリアされる | **根拠不足**（カーネル側md.cの詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- カーネル側のmd(4)ドライバ（sys/dev/md/md.c）の詳細実装は未確認
  - 候補：sys/dev/md/md.c / sys/sys/mdioctl.h

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ユーザ空間コマンドの処理フローはソースコードから確認済み
- 1: 中リスク - カーネル側の挙動（ゼロクリア等）については追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] mdconfigの4つのアクション（ATTACH/DETACH/RESIZE/LIST）が正確に記述されているか
- [ ] mdmfsのauto/tmpfs/md分岐ロジックが正確か
- [ ] サイズサフィックス解析の記述が正確か
- [ ] カーネル側のswapタイプ初期化動作を確認
