---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：33-スワップ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **NSWAPDEV制限値の具体的な値**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/swapon/swapon.c` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.33）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 単一バイナリで3つのコマンド名をサポート | E-01 (67行目 enum, 82-88行目) | ○ |
| C-02 | プログラム名に基づくモード切替 | E-01 (82-88行目 strstr) | ○ |
| C-03 | swapon()システムコールでスワップ有効化 | E-01 (751行目) | ○ |
| C-04 | swapoff()システムコールでスワップ無効化 | E-01 (753行目 swapoff with SWAPOFF_FORCE) | ○ |
| C-05 | vm.swap_info sysctlで一覧取得 | E-01 (851行目 sysctlnametomib) | ○ |
| C-06 | /etc/fstab走査で一括操作 | E-01 (173行目 getfsent) | ○ |
| C-07 | noautoエントリのスキップ | E-01 (176行目) | ○ |
| C-08 | late属性の制御 | E-01 (178-185行目) | ○ |
| C-09 | trimonceサポート | E-01 (186行目) | ○ |
| C-10 | GEOM ELI暗号化スワップ対応 | E-01 (246行目, 375-414行目) | ○ |
| C-11 | geli onetimeによるランダムキー暗号化 | E-01 (399行目 _PATH_GELI onetime) | ○ |
| C-12 | md(4)デバイスベーススワップ | E-01 (231-240行目, 416-627行目) | ○ |
| C-13 | TRIM操作（DIOCGDELETE） | E-01 (704-743行目 swapon_trim) | ○ |
| C-14 | ページサイズ基準の使用量計算 | E-01 (869-870行目) | ○ |
| C-15 | 人間可読表示サポート | E-01 (796-807行目 sizetobuf, humanize_number) | ○ |
| C-16 | -f強制swapoffフラグ | E-01 (753行目 SWAPOFF_FORCE) | ○ |
| C-17 | NSWAPDEV制限到達時のエラー | E-01 (762-763行目) | △ |

## 4) 不足情報（Unknown / Missing）
- NSWAPDEV制限値の具体的な定義元は未確認
  - 候補：sys/vm/swap_pager.c / カーネルヘッダ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローはソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] swapon/swapoff/swapctlの3モード切替が正確に記述されているか
- [ ] GEOM ELI暗号化スワップの処理フローが正確か
- [ ] md(4)ベーススワップの処理フローが正確か
- [ ] 画面機能マッピング（ZFSブート設定画面との関連）が正しいか
