---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：36-ルーティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **routedデーモンの実装詳細**：根拠不足
  2. **カーネルルーティングテーブル実装の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/route/route.c` - routeコマンドソース（先頭100行）
- E-02: `sbin/route/` - ディレクトリ一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.36）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | routeコマンドでルーティングテーブルのCRUD操作を行う | E-01, E-03 | ○ |
| C-02 | struct fiblでFIBリスト管理 | E-01 (68-74行目) | ○ |
| C-03 | keywordsテーブルでコマンドワード識別 | E-01 (76-82行目) | ○ |
| C-04 | PF_ROUTEソケットでカーネルと通信 | E-01 (34行目 sys/socket.h, 44行目 net/route.h) | ○ |
| C-05 | verbose, nflag等のグローバルフラグ | E-01 (84-100行目) | ○ |
| C-06 | jail対応（-jオプション） | E-01 (35-36行目 JAIL ifdef) | ○ |
| C-07 | route_netlink.cでNetlink対応 | E-02 (ファイル存在確認) | ○ |
| C-08 | keywordsファイルからコマンドワード定義を読み込む | E-02 (keywordsファイル存在) | ○ |
| C-09 | testsディレクトリにテストコード存在 | E-02 (testsディレクトリ存在) | ○ |
| C-10 | rtm_addrsでアドレスマスク管理 | E-01 (89行目) | ○ |
| C-11 | defaultfib, numfibsでFIB管理 | E-01 (95-96行目) | ○ |
| C-12 | uid記録 | E-01 (94行目) | ○ |
| C-13 | routedデーモンによるRIP動的ルーティング | **根拠不足**（sbin/routedの詳細未確認） | △ |
| C-14 | DXRアルゴリズムによる高速ルーティング参照 | **根拠不足**（カーネルルーティングコード未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- routedデーモンの実装詳細
  - 候補：sbin/routed/
- カーネルルーティングテーブルの実装（DXR等）
  - 候補：sys/net/route.c / sys/netinet/in_fib_dxr.c

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - routeコマンドの基本構造はソースコードから確認済み
- 1: 中リスク - routedデーモンとカーネル側ルーティングの詳細は追加確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] routeコマンドの全サブコマンド（add/delete/change/get/flush/monitor）が記述されているか
- [ ] FIBルーティングの説明が正確か
- [ ] Netlink対応の記述を確認
- [ ] routedデーモンの記述をsbin/routed/ソースと照合
