---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：39-netgraph

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **ng_typeメソッドテーブルの詳細**：根拠不足
  2. **キュー処理/スレッドモデルの詳細**：根拠不足
  3. **ngctl(8)コマンドの詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/netgraph/ng_base.c` - netgraph基盤ソース（先頭100行）
- E-02: `sys/netgraph/` - ディレクトリ一覧
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.39）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | netgraphはモジュラーネットワーキングフレームワーク | E-01, E-03 | ○ |
| C-02 | Whistle Communications社により開発 | E-01 (1-37行目 著作権表示) | ○ |
| C-03 | Julian Elischer氏とArchie Cobbs氏が著者 | E-01 (34-35行目) | ○ |
| C-04 | MODULE_VERSIONでABIバージョン管理 | E-01 (76行目) | ○ |
| C-05 | ng_topo_lockでトポロジー変更を保護 | E-01 (79-84行目) | ○ |
| C-06 | NETGRAPH_DEBUGモードで全ノード/フックリスト管理 | E-01 (86-99行目) | ○ |
| C-07 | ng_message.h, netgraph.h, ng_parse.hをinclude | E-01 (72-74行目) | ○ |
| C-08 | epoch, refcount, rwlockを使用 | E-01 (56-59行目) | ○ |
| C-09 | netisrとの連携 | E-01 (69行目) | ○ |
| C-10 | VNETサポート | E-01 (70行目) | ○ |
| C-11 | ng_echo, ng_ether, ng_bridge等の多数のノードタイプ | E-02 (ディレクトリ一覧) | ○ |
| C-12 | bluetooth/, netflow/サブディレクトリ | E-02 (ディレクトリ一覧) | ○ |
| C-13 | ng_typeの5メソッド（constructor, rcvmsg, rcvdata, shutdown, newhook） | **根拠不足**（netgraph.h未確認） | △ |
| C-14 | キュー処理/netisr的スレッドモデル | **根拠不足**（ng_base.cの詳細未確認） | △ |
| C-15 | ngctl(8)によるユーザ空間制御 | **根拠不足**（ngctl未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- netgraph.hのng_type構造体定義
  - 候補：sys/netgraph/netgraph.h
- ng_base.cのキュー処理・スレッドモデル詳細
  - 候補：sys/netgraph/ng_base.c（100行目以降）
- ngctl(8)の実装
  - 候補：usr.sbin/ngctl/

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - フレームワークの基本概念は確認済みだが、詳細APIとスレッドモデルは追加確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] ノードタイプのメソッドテーブル定義が正確か（netgraph.hと照合）
- [ ] データ転送パスの記述が正確か
- [ ] トポロジーロックの使い分け（読取ロック/書込ロック）が正確か
- [ ] 主要ノードタイプ一覧の網羅性を確認
