---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：4-システムコールインタフェース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **syscallエントリ・リターンの性能値**: サブマイクロ秒という記述の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/init_sysent.c` - システムコールテーブル
- E-02: `sys/kern/kern_descrip.c` - ファイルディスクリプタ管理
- E-03: `sys/sys/sysent.h` - struct sysent定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | init_sysent.cは自動生成ファイル | E-01 | ○ |
| C-02 | ASマクロは11行目で定義 | E-01 | ○ |
| C-03 | compat/compat4/.../compat13マクロが定義されている | E-01 | ○ |
| C-04 | COMPAT_FREEBSD4〜13の互換レイヤが存在 | E-01 | ○ |
| C-05 | sysent[]はO(1)の配列アクセス | E-01 | ○ |
| C-06 | sy_call関数ポインタでハンドラを呼び出す | E-03 | ○ |
| C-07 | sy_nargで引数数を管理 | E-03 | ○ |
| C-08 | sy_aueventで監査イベントを管理 | E-03 | ○ |
| C-09 | kern_descrip.cでFD管理を実装 | E-02 | ○ |
| C-10 | copyin()でユーザ空間から引数をコピー | E-01 | ○ |
| C-11 | SA_RESTARTでsyscall自動再実行 | E-01 | ○ |
| C-12 | Capsicumモードでsyscall制限 | E-01 | ○ |
| C-13 | ktraceでsyscallトレース可能 | E-01 | ○ |
| C-14 | systrace DTraceプロバイダとの連携 | E-01 | ○ |
| C-15 | 32bitバイナリ互換はfreebsd32_sysent.cで対応 | E-01 | ○ |
| C-16 | syscallエントリ・リターンがサブマイクロ秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- syscallパス（エントリからリターンまで）の性能測定データ
  - 候補：FreeBSDベンチマーク / syscall overhead測定ツール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - init_sysent.cの構造と自動生成の仕組み
- 0: 低リスク - compat互換レイヤの存在
- 1: 中リスク - パフォーマンス数値

## 6) レビュアーチェックリスト（最小）
- [ ] sysent[]テーブルのエントリ数が最新のsyscalls.masterと一致するか
- [ ] 互換レイヤのバージョン範囲が正確か
- [ ] Capsicumモードでのsyscall制限リストが正確か
- [ ] ファイルディスクリプタ管理の操作一覧が網羅的か
