---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：40-NetLink

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **NETLINK_ROUTEハンドラの詳細処理**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/netlink/netlink_module.c` - モジュール初期化ソース
- E-02: `sys/netlink/netlink_domain.c` - ソケットドメインソース（先頭80行）
- E-03: `sys/netlink/` - ディレクトリ一覧
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.40）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NetlinkはLinux由来のカーネル-ユーザ間通信プロトコル | E-04 | ○ |
| C-02 | NL_MAX_HANDLERS=20で最大20プロトコル | E-01 (54行目) | ○ |
| C-03 | nl_handlers配列でプロトコルハンドラ管理 | E-01 (55-56行目) | ○ |
| C-04 | VNET_DEFINE(struct nl_control)でVNET毎の制御構造 | E-01 (61-64行目) | ○ |
| C-05 | nl_global_mtxグローバルロック | E-01 (66-70行目) | ○ |
| C-06 | vnet_nl_init()でVNET初期化 | E-01 (74-85行目) | ○ |
| C-07 | nl_verify_proto()でプロトコル番号検証 | E-01 (101-109行目) | ○ |
| C-08 | netlink_register_proto()でハンドラ登録 | E-01 (117-129行目) | ○ |
| C-09 | netlink_unregister_proto()でハンドラ解除 | E-01 (131-143行目) | ○ |
| C-10 | can_unload()でアクティブソケット確認 | E-01 (162-182行目) | ○ |
| C-11 | MOD_LOAD/MOD_UNLOAD処理 | E-01 (184-217行目) | ○ |
| C-12 | NLP_MAX_GROUPS制約（64の倍数、最低64） | E-02 (62-65行目) | ○ |
| C-13 | rm_lockベースのNLCTLロック | E-02 (67-74行目) | ○ |
| C-14 | nl_sendspace/nl_recvspace sysctl | E-02 (76-80行目) | ○ |
| C-15 | FEATURE(netlink)宣言 | E-01 (46行目) | ○ |
| C-16 | NETLINK_ROUTEハンドラの詳細処理 | **根拠不足**（netlink_route.c未詳細確認） | △ |

## 4) 不足情報（Unknown / Missing）
- netlink_route.cのルーティングハンドラ詳細
  - 候補：sys/netlink/netlink_route.c / sys/netlink/route/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール初期化とプロトコルハンドラ登録はソースコードから詳細確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] プロトコルハンドラ登録/解除の動作が正確か
- [ ] VNET初期化/終了処理が正確か
- [ ] can_unload()のアンロード制限ロジックが正確か
- [ ] NETLINK_ROUTEハンドラの詳細処理をnetlink_route.cと照合
