---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：41-IPFW

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：定量的なベンチマーク根拠なし
  2. **jail環境での詳細制約**：jail固有のIPFW動作仕様の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sbin/ipfw/main.c` - メインエントリーポイント・コマンドディスパッチ
- E-02: `sbin/ipfw/ipfw2.h` - データ構造・トークン定義
- E-03: `sbin/ipfw/ipfw2.c` - ルール追加・削除・表示処理
- E-04: `sys/netpfil/ipfw/ip_fw2.c` - カーネルパケットフィルタリングエンジン
- E-05: `sys/netpfil/ipfw/ip_fw_sockopt.c` - ソケットオプション処理
- E-06: `sys/netpfil/ipfw/ip_fw_pfil.c` - pfilフック登録
- E-07: `sys/netpfil/ipfw/ip_fw_dynamic.c` - 動的ルール管理
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPFWはFreeBSD標準のステートフルファイアウォール | E-08 | ○ |
| C-02 | main()でプログラム名判定（ipfw/dnctl） | E-01（688-691行目） | ○ |
| C-03 | ipfw_main()でコマンドディスパッチ | E-01（105-510行目） | ○ |
| C-04 | cmdline_opts構造体でオプション管理 | E-02（35-62行目） | ○ |
| C-05 | enum tokensでルール構文トークン定義 | E-02（89-331行目） | ○ |
| C-06 | IP_FW3ソケットオプション経由でカーネル操作 | E-05 | ○ |
| C-07 | pfilフック経由でパケットフィルタリング | E-06 | ○ |
| C-08 | ルール番号65535がデフォルトルール | E-02（resvd_set_number参照） | ○ |
| C-09 | セット番号31が予約セット | E-02（398-402行目のコメント） | ○ |
| C-10 | ipfw_readfileでファイルからルール読み込み | E-01（513-668行目） | ○ |
| C-11 | do_cmd()でソケットオプション発行 | E-02（375-377行目） | ○ |
| C-12 | root権限(PRIV_NETINET_IPFW)が必要 | E-05 | ○ |
| C-13 | dummynetでトラフィックシェーピング | E-04, E-08 | ○ |
| C-14 | NAT64/NPTv6サポート | E-01（480-487行目） | ○ |
| C-15 | テーブルルックアップはハッシュまたは基数木 | E-04 | ○ |
| C-16 | rwlock/rmlockによるルール操作の排他制御 | E-04, E-05 | ○ |
| C-17 | プリプロセッサ経由のファイル読み込みサポート | E-01（544-567行目） | ○ |
| C-18 | ルール評価はO(n)で番号昇順 | E-04 | ○ |
| C-19 | パフォーマンス要件の具体値（遅延やスループット） | **根拠なし** | △ |
| C-20 | jail環境でのルールセット制限の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の定量的データ：ベンチマーク結果やソースコード内の具体的制約値が不明
  - 候補：ipfw(8)マニュアル / FreeBSD性能テスト文書 / カーネルソースのsysctl変数
- jail環境でのIPFW詳細動作：kern_jail.cとの連携部分の詳細確認が必要
  - 候補：sys/kern/kern_jail.c / jail(8)マニュアル / ipfw(8)のjailセクション

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なコマンド構造・処理フローの記述は十分な根拠あり
- 1: 中リスク - パフォーマンス要件は定性的記述にとどまり定量根拠なし
- 0: 低リスク - セキュリティ考慮事項はソースコードの権限チェックに基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ipfw_chk()の巨大なswitch文のアクション種別が網羅されているか確認
- [ ] dummynetの各スケジューラ（FIFO, FQ-CoDel, FQ-PIE等）の説明が十分か確認
- [ ] NAT64/NPTv6の処理フローが実際のソースと整合しているか確認
- [ ] jail環境でのIPFW制約を実機またはソースで検証
