---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：43-IPFilter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **ルール評価のfirst-match/last-match詳細**：quickキーワードの挙動の詳細確認が必要
  2. **ipfsync同期機能の詳細仕様**：状態同期プロトコルの詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/ipf/` - IPFilterユーザ空間ツール群のディレクトリ構造確認
- E-02: `sys/netpfil/ipfilter/netinet/` - カーネルIPFilter実装ディレクトリ確認
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IPFilterはDarren Reed開発のパケットフィルタ | E-03 | ○ |
| C-02 | ipf/ipnat/ippool/ipmon/ipfstatのツール群 | E-01 | ○ |
| C-03 | sbin/ipf配下にコマンド群が存在 | E-01 | ○ |
| C-04 | sys/netpfil/ipfilter配下にカーネル実装 | E-02 | ○ |
| C-05 | libipfによる共通ライブラリ提供 | E-01（libipfディレクトリ確認） | ○ |
| C-06 | pfilフレームワーク経由の統合 | E-02 | ○ |
| C-07 | /dev/ipf等のデバイスファイル経由 | E-02 | ○ |
| C-08 | ステートフルインスペクション | E-02 | ○ |
| C-09 | NAT機能 | E-01（ipnatコマンド確認） | ○ |
| C-10 | IPプール機能 | E-01（ippoolコマンド確認） | ○ |
| C-11 | ipmonログ監視 | E-01（ipmonコマンド確認） | ○ |
| C-12 | ipfsync状態同期 | E-01（ipfsyncコマンド確認） | ○ |
| C-13 | テスト用ツール（ipftest/ipsend） | E-01（ipftest, ipsendディレクトリ確認） | ○ |
| C-14 | first-match/last-match評価の詳細動作 | **根拠なし** | △ |
| C-15 | ipfsync同期プロトコル詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルール評価順序の詳細：quickキーワードの有無による評価順序の変更の詳細
  - 候補：fil.cのfr_check()関数内ロジック / ipf(5)マニュアル
- ipfsync同期プロトコル：同期メッセージフォーマットと障害時の挙動
  - 候補：ipfsync.cの詳細読解 / ipfsync(8)マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ディレクトリ構造とツール群の存在は確認済み
- 1: 中リスク - カーネル内部の詳細ロジックはソース深部の読解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] IPFilterのルール構文（ipf.rules）の記述が正確か確認
- [ ] NATルール構文（ipnat.rules）の記述が正確か確認
- [ ] カーネルモジュール名（ipl）が正しいか確認
- [ ] FreeBSD固有の統合部分（ip_fil_freebsd.c）の内容確認
