---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：45-audit（セキュリティ監査）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **auditdデーモンの詳細動作**：usr.sbin/auditd のソースコード未確認
  2. **監査設定ファイルの詳細フォーマット**：/etc/security/配下のファイル形式の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/security/audit/audit.c` - 監査中核（38-79行目ヘッダ確認）
- E-02: `sys/security/audit/audit_syscalls.c` - システムコール監査フック
- E-03: `sys/security/audit/audit_arg.c` - 引数収集
- E-04: `sys/security/audit/bsm_token.c` - BSMトークンエンコード
- E-05: `sys/security/audit/audit_worker.c` - ワーカースレッド
- E-06: `sys/security/audit/audit_pipe.c` - 監査パイプ
- E-07: `sys/security/audit/audit_dtrace.c` - DTrace連携
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BSMベースのセキュリティ監査 | E-01（bsm/audit.hインクルード） | ○ |
| C-02 | システムコールフレームワークとの統合 | E-02 | ○ |
| C-03 | BSMトークン形式でのエンコード | E-04 | ○ |
| C-04 | ワーカースレッドによる非同期書き込み | E-05 | ○ |
| C-05 | 監査パイプによるリアルタイム配信 | E-06 | ○ |
| C-06 | DTrace連携 | E-07 | ○ |
| C-07 | 引数収集関数群の存在 | E-03 | ○ |
| C-08 | audit_private.h内部構造 | ディレクトリ一覧で確認 | ○ |
| C-09 | audit_ioctl.h ioctl定義 | ディレクトリ一覧で確認 | ○ |
| C-10 | bsm_errno.c等のBSM変換関数 | ディレクトリ一覧で確認 | ○ |
| C-11 | audit_trigger.cトリガー通知 | ディレクトリ一覧で確認 | ○ |
| C-12 | カーネルヘッダインクルード構成 | E-01（38-79行目） | ○ |
| C-13 | macOSでの同一BSM形式使用 | 一般知識 | ○ |
| C-14 | Sun Microsystems由来 | 一般知識 | ○ |
| C-15 | auditdの詳細トレイル管理動作 | **根拠なし** | △ |
| C-16 | /etc/security/配下の設定ファイル形式詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- auditdデーモンの詳細動作：usr.sbin/auditd配下のソースコードが未確認
  - 候補：usr.sbin/auditd/ / auditd(8)マニュアル
- 設定ファイルの詳細フォーマット：audit_control(5), audit_user(5)のマニュアルが未確認
  - 候補：/etc/security/配下のサンプル / マニュアルページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カーネル監査機構のアーキテクチャ記述は十分
- 1: 中リスク - ユーザ空間ツール（auditd/auditreduce/praudit）の詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] BSMトークンの主要タイプが正しく列挙されているか確認
- [ ] 監査クラス（lo,aa,ad,pc,ex等）の説明が正確か確認
- [ ] auditdのトレイルローテーション動作を実機検証
- [ ] DTrace連携の具体的プローブ名を確認
