---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：46-Capsicum（ケイパビリティモード）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **kern_capsicum.cの詳細実装**：システムコール実装の行番号レベルの確認が必要
  2. **Casperサービスモジュールの完全一覧**：全サービスの網羅確認

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/libcapsicum/capsicum_helpers.h` - ヘルパー関数（42-76行目確認）
- E-02: `lib/libcasper/` - Casperデーモンディレクトリ構造確認
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ケイパビリティベースセキュリティ | E-03 | ○ |
| C-02 | capsicum_helpers.hのフラグ定義 | E-01（42-45行目） | ○ |
| C-03 | caph_stream_rights()の権限セット | E-01（63-76行目） | ○ |
| C-04 | caph_stream_cmdsのioctl制限 | E-01（49-60行目） | ○ |
| C-05 | cap_rights_init()による権限初期化 | E-01（67行目） | ○ |
| C-06 | CAPH_READ/WRITE/LOOKUPフラグ | E-01（43-45行目） | ○ |
| C-07 | libcasper経由のサービスアクセス | E-01（40行目libcasper.hインクルード）, E-02 | ○ |
| C-08 | Casperサービスディレクトリの存在 | E-02 | ○ |
| C-09 | cap_enter()による不可逆的遷移 | 一般知識（FreeBSD capsicum(4)） | ○ |
| C-10 | cap_rights_limit()による権限制限 | 一般知識 | ○ |
| C-11 | ECAPMODEエラー | 一般知識 | ○ |
| C-12 | ENOTCAPABLEエラー | 一般知識 | ○ |
| C-13 | gzip/tar/tcpdump等のCapsicum対応 | 一般知識 | ○ |
| C-14 | 子プロセスへのケイパビリティモード継承 | 一般知識 | ○ |
| C-15 | kern_capsicum.cの詳細実装 | **根拠なし** | △ |
| C-16 | Casperサービスモジュール完全一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- kern_capsicum.cの詳細：cap_enter()のカーネル実装の具体的行番号
  - 候補：sys/kern/kern_capsicum.c のソース読解
- Casperサービス完全一覧：lib/libcasper/services/配下の全モジュール
  - 候補：lib/libcasper/services/のディレクトリ列挙

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - capsicum_helpers.hの記述は直接ソースコードで確認済み
- 1: 中リスク - カーネル側実装の詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] cap_rights_tの主要権限フラグが網羅されているか確認
- [ ] kern_capsicum.cの実装が記述と整合しているか確認
- [ ] Casperサービスの全モジュールが列挙されているか確認
- [ ] Capsicum対応済み標準ツールの一覧が最新か確認
