---
generated_at: 2026-02-01 11:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：47-veriexec（実行ファイル検証）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **状態遷移の詳細仕様**：loaded/active/enforce/lockedの遷移条件の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/security/mac_veriexec/mac_veriexec.c` - MACポリシーモジュール（65-80行目確認）
- E-02: `sys/security/mac_veriexec/mac_veriexec_internal.h` - 内部ヘッダ
- E-03: `sys/security/mac_veriexec/` - ハッシュ実装ファイル群確認
- E-04: `sbin/veriexec/` - コマンドディレクトリ確認
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MACフレームワーク上のポリシーモジュール | E-01（59-60行目mac_framework.h, mac_policy.hインクルード） | ○ |
| C-02 | SLOTマクロによるラベル管理 | E-01（65-68行目） | ○ |
| C-03 | デバッグマクロ定義 | E-01（70-78行目） | ○ |
| C-04 | sysctl_mac_veriexec_state関数 | E-01（80行目） | ○ |
| C-05 | SHA1/256/384/512サポート | E-03（各ファイル確認） | ○ |
| C-06 | veriexec_fingerprint.cフィンガープリント計算 | E-03 | ○ |
| C-07 | veriexec_metadata.cメタデータ管理 | E-03 | ○ |
| C-08 | manifest_parser.yパーサー | E-04 | ○ |
| C-09 | manifest_lexer.l字句解析 | E-04 | ○ |
| C-10 | veriexec.cコマンド実装 | E-04 | ○ |
| C-11 | Juniper Networks社の貢献 | E-01（2-4行目Copyright） | ○ |
| C-12 | Capsicumオプション参照 | E-01（31行目opt_capsicum.h） | ○ |
| C-13 | nullfs統合 | E-01（58行目fs/nullfs/null.h） | ○ |
| C-14 | COMPAT_FREEBSD32対応 | E-01（53-57行目） | ○ |
| C-15 | 状態遷移（loaded/active/enforce/locked）の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 状態遷移の詳細仕様：各状態の遷移条件と許可される操作の詳細
  - 候補：mac_veriexec.cの深部読解 / sysctl_mac_veriexec_state()実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの構造とファイル一覧は直接確認済み
- 1: 中リスク - 検証ロジックの詳細な動作フローは追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] マニフェストファイルの構文が正確に記述されているか確認
- [ ] 状態遷移（loaded→active→enforce→locked）の詳細を実機検証
- [ ] nullfsマウント経由の検証動作が正しく記述されているか確認
- [ ] SHA1非推奨の記述が適切か確認
