---
generated_at: 2026-02-01 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：48-暗号化ライブラリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **OpenSSLの具体的バージョンとAPI詳細**：同梱バージョンの確認が必要
  2. **HWアクセラレータドライバの完全一覧**：サポートされるHWの網羅確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/opencrypto/crypto.c` - 暗号フレームワーク中核（29-57行目コメント確認）
- E-02: `sys/opencrypto/` - opencryptoディレクトリ全体のファイル一覧確認
- E-03: `crypto/openssl/` - OpenSSLソースツリーの存在確認
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OCF由来の暗号フレームワーク | E-01（29-57行目コメント） | ○ |
| C-02 | crypto.cが暗号サブシステム中核 | E-01 | ○ |
| C-03 | cryptosoft.cソフトウェアドライバ | E-02 | ○ |
| C-04 | cryptodev.c /dev/cryptoデバイス | E-02 | ○ |
| C-05 | ktls_ocf.c カーネルTLS統合 | E-02 | ○ |
| C-06 | xform_aes_cbc.c変換モジュール | E-02 | ○ |
| C-07 | gmac.c/gfmult.c GCM関連 | E-02 | ○ |
| C-08 | cbc_mac.c CBC-MAC | E-02 | ○ |
| C-09 | OpenSSLソースツリーの存在 | E-03 | ○ |
| C-10 | cryptodev.h構造体定義 | E-02 | ○ |
| C-11 | rmd160.c RIPEMDハッシュ | E-02 | ○ |
| C-12 | criov.c I/Oベクトル暗号 | E-02 | ○ |
| C-13 | cryptodeflate.c 圧縮暗号 | E-02 | ○ |
| C-14 | OpenSSLの具体的バージョンとAPI | **根拠なし** | △ |
| C-15 | HWアクセラレータドライバ一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OpenSSLのバージョン：crypto/openssl/配下のバージョン情報ファイル確認が必要
  - 候補：crypto/openssl/CHANGES.md / crypto/openssl/build.info
- HWアクセラレータドライバ：sys/dev/配下の暗号HWドライバ一覧
  - 候補：sys/dev/cesa/ / sys/dev/armv8crypto/ / aesni関連

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - opencryptoフレームワークの基本構造は確認済み
- 1: 中リスク - サポートされる全暗号アルゴリズムの網羅性は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSLのバージョンが最新か確認
- [ ] サポートされる暗号アルゴリズム一覧が正確か確認
- [ ] HWアクセラレータドライバ（AES-NI等）の記述が正確か確認
- [ ] ktls統合の対応暗号スイートが正しいか確認
