---
generated_at: 2026-02-01 11:20:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：49-IPsec

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **IKEデーモン連携の詳細**：strongSwan/racoon等との具体的連携仕様
  2. **IPsecオフロード対応NIC一覧**：サポートされるNICの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/netipsec/ipsec.c` - IPsecコントローラ（1-80行目確認）
- E-02: `sys/netipsec/` - netipsecディレクトリ全体のファイル一覧
- E-03: `sbin/setkey/` - setkeyディレクトリ構造確認
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KAME由来のIPsec実装 | E-01（1行目$KAME$タグ） | ○ |
| C-02 | IPsec controller part | E-01（34-36行目コメント） | ○ |
| C-03 | ESP/AH/IPCompサポート | E-02（xform_esp.c, xform_ah.c, xform_ipcomp.c確認） | ○ |
| C-04 | key.c PF_KEY管理 | E-02 | ○ |
| C-05 | keysock.c PF_KEYソケット | E-02 | ○ |
| C-06 | ipsec_input.c受信処理 | E-02 | ○ |
| C-07 | ipsec_output.c送信処理 | E-02 | ○ |
| C-08 | ipsec_pcb.cソケット単位ポリシー | E-02 | ○ |
| C-09 | ipsec_offload.c NICオフロード | E-02 | ○ |
| C-10 | udpencap.c UDP encapsulation | E-02 | ○ |
| C-11 | setkeyコマンドの存在 | E-03 | ○ |
| C-12 | parse.yパーサー | E-03 | ○ |
| C-13 | token.l字句解析 | E-03 | ○ |
| C-14 | key_debug.cデバッグ | E-02 | ○ |
| C-15 | ipsec_mod.cモジュール管理 | E-02 | ○ |
| C-16 | IKEデーモン連携の詳細仕様 | **根拠なし** | △ |
| C-17 | IPsecオフロード対応NIC一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- IKEデーモン連携：PF_KEY v2のSADB_ACQUIREフローとIKEデーモンとの連携詳細
  - 候補：key.cのSADB_ACQUIREハンドラ / racoon/strongSWanドキュメント
- IPsecオフロード対応NIC：ipsec_offload.cの対応ドライバ一覧
  - 候補：ipsec_offload.hの定義 / NICドライバソース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - IPsecの基本アーキテクチャ（ESP/AH/SPD/SAD）は確認済み
- 1: 中リスク - IKEデーモン連携とオフロード詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ESP暗号化のサポートアルゴリズム一覧が正確か確認
- [ ] AH認証のサポートアルゴリズム一覧が正確か確認
- [ ] PF_KEY v2メッセージタイプが網羅されているか確認
- [ ] NAT-Traversal（UDP encapsulation）の動作確認
