---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-タイマー・クロック管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RADclockアルゴリズムの詳細**: ffclock実装の具体的動作確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/kern/kern_clock.c` - hardclock/statclock実装（841行）
- E-02: `sys/kern/kern_clocksource.c` - クロックソース管理（984行）
- E-03: `sys/kern/kern_et.c` - イベントタイマー（263行）
- E-04: `sys/kern/kern_ffclock.c` - フィードフォワードクロック
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hardclock()は477行目に定義 | E-01 | ○ |
| C-02 | hardclock_itimer()は450行目に定義 | E-01 | ○ |
| C-03 | hardclock_sync()は542行目に定義 | E-01 | ○ |
| C-04 | statclock()は685行目に定義 | E-01 | ○ |
| C-05 | kern_clock.cは841行 | E-01 | ○ |
| C-06 | kern_clocksource.cは984行 | E-02 | ○ |
| C-07 | kern_et.cは263行 | E-03 | ○ |
| C-08 | デフォルトHZ=1000 | E-01 | ○ |
| C-09 | timecounterとeventtimerの二本柱構造 | E-01, E-02, E-03 | ○ |
| C-10 | 画面22がタイムゾーン選択画面 | E-06 | ○ |
| C-11 | 画面23が日付設定画面 | E-06 | ○ |
| C-12 | 画面24が時刻設定画面 | E-06 | ○ |
| C-13 | 画面30から遷移あり | E-06 | ○ |
| C-14 | CLOCK_MONOTONICは後退しない | E-01 | ○ |
| C-15 | settimeofday()にroot権限必要 | E-01 | ○ |
| C-16 | seqclockによるロックフリー読み取り | E-01 | ○ |
| C-17 | calloutサブシステムとの連携 | E-01 | ○ |
| C-18 | RADclockアルゴリズムの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RADclockアルゴリズムの具体的な実装詳細
  - 候補：kern_ffclock.cの詳細読解 / RADclock論文

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - hardclock/statclockの行番号と機能
- 0: 低リスク - 関連画面の対応
- 1: 中リスク - ffclockの詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] hardclock()の処理順序が正確か
- [ ] timecounterのロックフリー読み取り機構が正しく記述されているか
- [ ] イベントタイマーの抽象化レイヤの記述が正確か
- [ ] 関連画面のマッピングが画面機能マッピング.csvと一致するか
