---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：51-SSH

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体数値**：ベンチマーク根拠なし
  2. **暗号化オーバーヘッド5-10%**：定量的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `crypto/openssh/ssh.c` - SSHクライアントソースコード
- E-02: `crypto/openssh/sshd.c` - SSHサーバソースコード
- E-03: `crypto/openssh/sshconnect2.c` - SSH2接続処理
- E-04: `crypto/openssh/auth2-pubkey.c` - 公開鍵認証
- E-05: `crypto/openssh/auth-pam.c` - PAM認証連携
- E-06: `secure/usr.bin/` - クライアントビルドディレクトリ
- E-07: `secure/usr.sbin/` - サーバビルドディレクトリ
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenSSHベースのSSH実装である | E-01, E-02 | ○ |
| C-02 | crypto/openssh/以下にソースがある | E-01 | ○ |
| C-03 | sshdはroot権限で起動し特権分離を行う | E-02 (75-82行, 151-156行) | ○ |
| C-04 | MaxStartups制限の仕組み | E-02 (139-141行, 167-199行) | ○ |
| C-05 | 公開鍵認証・パスワード認証・GSSAPI認証をサポート | E-02 (77-80行), E-04 | ○ |
| C-06 | ssh.cのusage()でコマンドラインオプションを定義 | E-01 (180-194行) | ○ |
| C-07 | ControlMaster/ControlPersist多重接続をサポート | E-01 (134行) | ○ |
| C-08 | sshconnect2.cが約2365行 | E-03 | ○ |
| C-09 | FreeBSD固有パッチが#ifdef __FreeBSD__で囲まれている | E-02 (75行) | ○ |
| C-10 | secure/usr.bin/, secure/usr.sbin/でビルド | E-06, E-07 | ○ |
| C-11 | サービス選択画面(No.25)でsshd設定 | E-08 | ○ |
| C-12 | Options構造体でクライアント設定を管理 | E-01 (144行) | ○ |
| C-13 | sensitive_data構造体でホスト鍵を管理 | E-02 (151-156行) | ○ |
| C-14 | early_child構造体で子プロセスを追跡 | E-02 (193-199行) | ○ |
| C-15 | MAX_LISTEN_SOCKSは16 | E-02 (139行) | ○ |
| C-16 | PAM認証連携をサポート | E-05 | ○ |
| C-17 | blocklist連携がFreeBSD固有パッチとして存在 | E-01 (blocklist_client.h存在確認) | ○ |
| C-18 | ポート番号デフォルト22 | E-01 (SSHプロトコル標準) | ○ |
| C-19 | 接続確立時間1-3秒以内 | **根拠なし** | △ |
| C-20 | 暗号化オーバーヘッド5-10% | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は一般的な知見に基づくものであり、FreeBSD固有のベンチマークデータは確認できなかった
  - 候補：FreeBSD公式ベンチマーク / OpenSSHリリースノート / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要、関連画面、処理フローは正確
- 0: 低リスク - コードリーディングガイドの行番号はソースコードと一致
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] sshdの特権分離処理の詳細が最新バージョンと一致しているか確認
- [ ] パフォーマンス要件の数値が実運用環境で妥当か確認
- [ ] FreeBSD固有パッチの一覧が網羅的か確認
