---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-ACL管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **MACフレームワークとの共存**：具体的な連携コード未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/getfacl/getfacl.c` - getfaclソースコード
- E-02: `bin/setfacl/setfacl.c` - setfaclソースコード
- E-03: `bin/setfacl/setfacl.h` - setfaclヘッダ
- E-04: `bin/setfacl/merge.c` - ACLマージ処理
- E-05: `bin/setfacl/remove.c` - ACL削除処理
- E-06: `bin/setfacl/mask.c` - マスク計算
- E-07: `bin/setfacl/util.c` - ユーティリティ
- E-08: `bin/setfacl/file.c` - ファイル読み込み
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getfaclはPOSIX.1eとNFSv4 ACLの両方に対応 | E-01 (110-124行) | ○ |
| C-02 | pathconf(_PC_ACL_NFS4)でACLタイプを判定 | E-01 (111-113行) | ○ |
| C-03 | acl_get_file/acl_get_link_npでACL取得 | E-01 (126-129行) | ○ |
| C-04 | acl_to_text_np()でテキスト変換 | E-01 (187行) | ○ |
| C-05 | -sオプションでtrivial ACLをスキップ | E-01 (136-158行) | ○ |
| C-06 | setfaclの操作定数OP_MERGE_ACL等 | E-02 (43-49行) | ○ |
| C-07 | sf_entry構造体によるTAILQ管理 | E-02 (52-57行) | ○ |
| C-08 | clear_inheritance_flags()で継承フラグ除去 | E-02 (130-168行) | ○ |
| C-09 | NFSv4 ACLにデフォルトACLが存在しない | E-01 (115-119行), E-02 (271-273行) | ○ |
| C-10 | FTSによるファイルツリー走査 | E-02 (170-180行) | ○ |
| C-11 | getfaclの著者はRobert N M Watson | E-01 (3行) | ○ |
| C-12 | setfaclの著者はChris D. Faulhaber | E-02 (3行) | ○ |
| C-13 | long_optionsにdefault,numeric,omit-header,skip-baseがある | E-01 (50-57行) | ○ |
| C-14 | getfaclのusageは"getfacl [-dhnqv] [file ...]" | E-01 (63行) | ○ |
| C-15 | acl_from_mode_np()でACL非対応時のフォールバック | E-01 (171行) | ○ |
| C-16 | ACL_TEXT_APPEND_ID等のフラグで表示制御 | E-01 (178-185行) | ○ |
| C-17 | handle_file()がファイル単位のACL操作コア | E-02 (170-340行) | ○ |
| C-18 | MACフレームワークとの共存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MACフレームワークとACLの共存に関する具体的な実装コードは本機能のソースコード内では確認できなかった
  - 候補：sys/security/mac*/内のACL連携コード / カーネルVFS層のACLチェック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - getfacl/setfaclのソースコードは単一ファイルまたは少数ファイルで構成されており、行番号の確認が容易
- 0: 低リスク - ACLタイプ判定ロジックはソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] POSIX.1e ACLとNFSv4 ACLの違いが正確に記述されているか
- [ ] 再帰モードでの継承フラグ処理が正確か
- [ ] MACフレームワークとの連携について補足が必要か確認
