---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：53-AHCIドライバ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **NCQ最大32コマンドの同時発行**：AHCI仕様に基づく一般知識だがコード内の具体的定数未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/ahci/ahci.h` - AHCIヘッダファイル
- E-02: `sys/dev/ahci/ahci.c` - AHCIドライバコア
- E-03: `sys/dev/ahci/ahci_pci.c` - PCI接続
- E-04: `sys/dev/ahci/ahciem.c` - エンクロージャ管理
- E-05: `sys/dev/ahci/ahci_generic.c` - 汎用対応
- E-06: `sys/dev/ahci/ahci_fsl_fdt.c` - Freescale FDT対応
- E-07: `sys/dev/ahci/ahci_mv_fdt.c` - Marvell FDT対応
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AHCIドライバはsys/dev/ahci/に存在 | E-01-E-07 | ○ |
| C-02 | ahci_intr等の割り込みハンドラが定義されている | E-02 (54-56行) | ○ |
| C-03 | ahci_ch_init/deinit/suspend/resumeのライフサイクル | E-02 (57-60行) | ○ |
| C-04 | ahci_begin_transaction/end_transactionでI/O処理 | E-02 (65, 69行) | ○ |
| C-05 | ahci_setup_fisでFISを構築 | E-02 (70行) | ○ |
| C-06 | ahci_dmasetprdでPRDTを設定 | E-02 (66行) | ○ |
| C-07 | ahci_resetでポートリセット | E-02 (76行) | ○ |
| C-08 | ahci_start/stopでポート制御 | E-02 (77-78行) | ○ |
| C-09 | CAM SIMとして登録される | E-02 (cam_sim.h include, 47-51行) | ○ |
| C-10 | ATAレジスタ定数がahci.hに定義 | E-01 (30-80行) | ○ |
| C-11 | Alexander Motinが開発者 | E-02 (5行) | ○ |
| C-12 | PCI/FDT/汎用の複数バックエンド | E-03, E-05, E-06, E-07 | ○ |
| C-13 | ahciem.cがエンクロージャ管理を担当 | E-04 | ○ |
| C-14 | DMAメモリ管理関数が存在 | E-02 (71-75行) | ○ |
| C-15 | コマンドスロット管理関数が存在 | E-02 (74-75行) | ○ |
| C-16 | NCQ最大32コマンド同時発行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NCQの最大キュー深度32はAHCI/SATA仕様の一般的知識であるが、ahci.c内の具体的なキュー深度定数の確認が必要
  - 候補：ahci.h内のコマンドスロット定数 / NCQ関連定数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構成、関数名はソースコードと一致
- 0: 低リスク - 開発者情報はコードのcopyrightヘッダと一致

## 6) レビュアーチェックリスト（最小）
- [ ] NCQキュー深度の具体的な定数値を確認
- [ ] エラーリカバリシーケンスの詳細が正確か確認
- [ ] CAM SIM登録の具体的な呼び出し箇所を確認
