---
generated_at: 2026-02-01 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：56-USBサブシステム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **USB 3.1 10Gbpsサポート**：xHCIドライバでのUSB 3.1対応の確認が必要
  2. **USB gadget機能の詳細**：gadget/ディレクトリの内容確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/usb/usb_core.c` - USBコアソースコード
- E-02: `sys/dev/usb/` ディレクトリ一覧 - USBサブシステムファイル構成
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sys/dev/usb/以下にUSBサブシステムが存在 | E-02 | ○ |
| C-02 | Hans Petter Selaskyが開発者 | E-01 (4行) | ○ |
| C-03 | controller/, input/, serial/, storage/, net/等のサブディレクトリ | E-02 | ○ |
| C-04 | usb_core.c, usb_device.c等のコアファイル | E-02 | ○ |
| C-05 | usb_busdma.cによるDMA管理 | E-02 | ○ |
| C-06 | usb_dev.cによるデバイスノード管理 | E-02 | ○ |
| C-07 | usb_dynamic.cによる動的モジュールローディング | E-02 | ○ |
| C-08 | usb_error.cによるエラーコード管理 | E-02 | ○ |
| C-09 | quirk/ディレクトリの存在 | E-02 | ○ |
| C-10 | gadget/ディレクトリの存在 | E-02 | ○ |
| C-11 | template/ディレクトリの存在 | E-02 | ○ |
| C-12 | USB仕様ドキュメントへの参照がコメントに含まれる | E-01 (28-31行) | ○ |
| C-13 | USB_GLOBAL_INCLUDE_FILE条件コンパイル | E-01 (34-36行) | ○ |
| C-14 | dev/usb/usb.hとdev/usb/usbdi.hのインクルード | E-01 (58-59行) | ○ |
| C-15 | USB 3.1 10Gbps対応 | **根拠なし** | △ |
| C-16 | USB gadget機能の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- USB 3.1の具体的なサポート状況はxHCIドライバの詳細確認が必要
  - 候補：sys/dev/usb/controller/xhci*.c
- USB gadget機能の詳細
  - 候補：sys/dev/usb/gadget/ ディレクトリ内のソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構成はディレクトリ一覧と一致
- 1: 中リスク - USB 3.x対応の具体的な実装状況は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] xHCIドライバのUSB 3.x対応状況を確認
- [ ] USB gadget機能の実装状況を確認
- [ ] 主要なUSBクラスドライバの一覧に漏れがないか確認
