---
generated_at: 2026-02-01 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：57-ACPIサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ARM ACPIサポートの詳細**：ARM系でのACPI採用状況の具体的確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/acpica/acpi.c` - ACPIコアドライバ
- E-02: `sys/dev/acpica/` ディレクトリ一覧 - ACPIファイル構成
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ACPICAインタプリタを使用 | E-01 (72-74行) | ○ |
| C-02 | acpi.cがコアドライバ | E-01 | ○ |
| C-03 | ACPICAヘッダはcontrib/dev/acpica/ | E-01 (72行) | ○ |
| C-04 | acpi_button.c等の個別ドライバが存在 | E-02 | ○ |
| C-05 | acpi_ec.c, acpi_cmbat.c, acpi_acad.c等 | E-02 | ○ |
| C-06 | acpi_cpu.cがCPU電力管理 | E-02 | ○ |
| C-07 | acpi_hpet.cがHPETタイマー管理 | E-02 | ○ |
| C-08 | acpi_pci.c/acpi_pci_link.cがPCI連携 | E-02 | ○ |
| C-09 | acpi_quirk.c/acpi_quirksが存在 | E-02 | ○ |
| C-10 | acpi_perf.cがCPU周波数制御 | E-02 | ○ |
| C-11 | acpi_resource.cがリソース管理 | E-02 | ○ |
| C-12 | acpi_dock.cがドックサポート | E-02 | ○ |
| C-13 | acpi_container.cが存在 | E-02 | ○ |
| C-14 | acpivar.h/acpiio.hがヘッダ | E-01 (76-77行) | ○ |
| C-15 | opt_acpi.hが構成オプション | E-01 (35行) | ○ |
| C-16 | 2025年にAymeric Wiboが貢献 | E-01 (7-10行) | ○ |
| C-17 | PCI変数ヘッダをインクルード | E-01 (79行) | ○ |
| C-18 | ARM系プラットフォームでのACPI採用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ARM系プラットフォームでのACPIサポート状況の具体的な確認
  - 候補：sys/arm64/acpica/ ディレクトリの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構成、ソースコード参照はすべて確認済み
- 0: 低リスク - ACPICAの使用はソースコードで明確に確認

## 6) レビュアーチェックリスト（最小）
- [ ] ARM64でのACPIサポート状況を確認
- [ ] acpi_quirksの最新状態を確認
- [ ] ACPICAのバージョンを確認
