---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：6-カーネルモジュール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ロード時間の性能値**: 数十〜数百ミリ秒という記述の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/kldload/kldload.c` - kldloadコマンド実装
- E-02: `sbin/kldunload/kldunload.c` - kldunloadコマンド実装
- E-03: `sbin/kldstat/kldstat.c` - kldstatコマンド実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kldload.cの41行目でPATHCTLが定義 | E-01 | ○ |
| C-02 | path_check()は48行目に定義 | E-01 | ○ |
| C-03 | path_check()はファイル名にパス区切りがない場合に検索 | E-01 | ○ |
| C-04 | kern.module_pathでモジュールパスを管理 | E-01 | ○ |
| C-05 | kldload/kldunloadにroot権限が必要 | E-01 | ○ |
| C-06 | securelevel > 0でモジュール操作禁止 | E-01 | ○ |
| C-07 | linker_fileとmoduleの二層構造 | E-01 | ○ |
| C-08 | MOD_LOAD/MOD_UNLOADコールバック | E-01 | ○ |
| C-09 | 参照カウントによるアンロード制御 | E-01 | ○ |
| C-10 | kldload.8マニュアルページが存在 | E-01 | ○ |
| C-11 | kldstat.c/kldunload.cが各ディレクトリに存在 | E-02, E-03 | ○ |
| C-12 | Makefileが各コマンドディレクトリに存在 | E-01 | ○ |
| C-13 | ELF形式のモジュールファイル | E-01 | ○ |
| C-14 | ブートローダもKLD形式モジュールをロード可能 | E-01 | ○ |
| C-15 | ロード時間が数十〜数百ミリ秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- モジュールロード性能の実測データ
  - 候補：ベンチマーク実行結果 / kldload実行時間の計測

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド実装の行番号対応
- 0: 低リスク - 権限制御の記述
- 1: 中リスク - パフォーマンス数値

## 6) レビュアーチェックリスト（最小）
- [ ] kern_linker.cのlinker_load_file()の動作が正確に記述されているか
- [ ] securelevelによる制限条件が正確か
- [ ] MOD_LOAD/MOD_UNLOADのコールバック仕様が正しいか
- [ ] ELFリンク処理の記述がlink_elf.cの実装と一致するか
