---
generated_at: 2026-02-01 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：60-コンソールドライバ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **securelevel設定によるコンソール操作制限の詳細**：具体的なsecurelevel値との対応確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/vt/vt.h` - VTヘッダファイル
- E-02: `sys/dev/vt/vt_core.c` - VTコアソースコード
- E-03: `sys/teken/teken.c` - tekenソースコード
- E-04: `sys/teken/teken.h` - tekenヘッダファイル
- E-05: `sys/dev/vt/` ディレクトリ一覧 - VTファイル構成
- E-06: `sys/teken/` ディレクトリ一覧 - tekenファイル構成
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VT_MAXWINDOWS=12（デフォルト） | E-01 (54-59行) | ○ |
| C-02 | VT_ALT_TO_ESC_HACK=1 | E-01 (62-64行) | ○ |
| C-03 | VT_CONSWINDOW=0 | E-01 (66行) | ○ |
| C-04 | マウスペーストボタン設定（68-74行） | E-01 (68-74行) | ○ |
| C-05 | SC_DRIVER_NAME="vt" | E-01 (76行) | ○ |
| C-06 | vtterm_bell等のtekenコールバック | E-02 (68-76行) | ○ |
| C-07 | vtterm_cnprobe/cngetc | E-02 (78-79行) | ○ |
| C-08 | vtterm_cngrab_noswitch | E-02 (65-66行) | ○ |
| C-09 | consio.h, fbio.h, font.h, kbio.hのインクルード | E-02 (35-48行) | ○ |
| C-10 | terminal.hのインクルード | E-02 (55行) | ○ |
| C-11 | Ed Schoutenが開発者 | E-02 (7行) | ○ |
| C-12 | Oleksandr Rybalkoが共同開発者 | E-02 (9-10行) | ○ |
| C-13 | FreeBSD Foundation支援 | E-02 (5-6行, 8-10行) | ○ |
| C-14 | teken関連ファイル（teken.c, teken.h等）の存在 | E-06 | ○ |
| C-15 | vt_buf.c, vt_font.c, vt_sysmouse.c等の存在 | E-05 | ○ |
| C-16 | hw/, colors/, font/, logo/ディレクトリの存在 | E-05 | ○ |
| C-17 | teken_wcwidth.h（ワイド文字幅）の存在 | E-06 | ○ |
| C-18 | securelevelによるコンソール制限の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- securelevelの具体的なレベルとコンソール操作制限の対応
  - 候補：sys/kern/kern_securelevel.c / security(7) manページ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - vt.hの定数値はソースコードと完全一致
- 0: 低リスク - vt_core.cの関数名、行番号は正確

## 6) レビュアーチェックリスト（最小）
- [ ] ハードウェアバックエンド（hw/ディレクトリ）の具体的な構成を確認
- [ ] securelevelとコンソール操作制限の対応を確認
- [ ] tekenのサポートするエスケープシーケンス一覧を確認
